BEM.DOM.decl({ block: 'b-campaigns-list', elem: 'total' }, {

    onSetMod: {
        js: function() {
            BEM.MODEL.on('m-campaign', 'day_budget2', 'change', function(e) {
                var mods,
                    dayBudgetSum,
                    isCommon = this.hasMod('common', 'yes'),
                    groupId = e.target.model.get('groupId', 'raw');

                if (!isCommon && u.beminize(groupId) !== this.getMod('group-id')) return;

                mods = { type: 'day-budget-sum' };

                dayBudgetSum = BEM.MODEL.get('m-campaign').reduce(function(sum, campaign) {
                    if (isCommon || groupId === campaign.get('groupId', 'raw')) {
                        sum += (campaign.get('day_budget2').get('sum') || 0);
                    }

                    return sum;
                }, 0);

                dayBudgetSum > 0 || (mods.hidden = 'yes');

                BEM.DOM.replace(this.findElem('total-item', 'type', 'day-budget-sum'), BEMHTML.apply({
                    block: 'b-campaigns-list',
                    elem: 'total-item',
                    elemMods: mods,
                    sum: u.numberFormatter.format(dayBudgetSum, 'money')
                }));
            }, this);
        }
    }

});
