block('b-campaigns-list')(

    def()(function() {
        var data = this.data,
            form = data.FORM,
            rights = data.login_rights,
            sorting = data.sorting,
            ctx = this.ctx,
            campaigns = ctx.campaigns || [],
            campaignsLength = campaigns.length,
            splitIntoGroups = ctx.splitIntoGroups,
            noTotal = ctx.noTotal,
            withSearch = ctx.withSearch,
            currency = ctx.currency || data.work_currency,
            campsGroups = {},
            campsGroupsKeys = [],
            group,
            isMyClient = false,
            defaultCol = sorting && sorting.sort || 'cid',
            uniqEmails = {},
            sortSettings = apply('getSortSettings'),
            can = apply('can'),
            key,
            agencyId = campaignsLength && campaigns[0].AgencyID,
            totalTemplate = {
                clicks: 0, // кликов
                sum: 0, // было денег
                'sum-rest': 0, // осталось денег
                shows: 0, // было показов
                'shows-rest': 0 // осталось показов
            },
            commonTotal = noTotal ? false : this.extend({}, totalTemplate),
            agenciesInfo = data.agencies_info || {},
            userOptions = data.USER_OPTIONS,
            pageParams = this.pageParams || {},
            auxParams = pageParams.auxParams,
            hasRightToSeeFavs = hasLoginRights('is_any_client', 'manager_control', 'agency_control', 'super_control',
                'support_control'),
            visibleFilter = {
                cidsFav: data.favorite_camps || {},
                cidsMy: {},
                flags: {
                    favs: data.show_favorites_filter && hasRightToSeeFavs && pageParams.withSearch &&
                        userOptions.show_favorite_campaigns_only == 'true',

                    // менеджер имеет право редактировать кампанию
                    // (показываем её при фильтре "Скрыть кампании других менеджеров");
                    my: userOptions.show_my_campaigns_only == 'true',
                    mediaType: userOptions.mediaType || 'all'
                }
            },
            massActions = [
                ['showCampStat', iget2('b-campaigns-list', 'pokazat-statistiku', 'Показать статистику')],
                ['resumeCamp', iget2('b-campaigns-list', 'vozobnovit-pokazy', 'Возобновить показы')],
                ['stopCamp', iget2('b-campaigns-list', 'ostanovit', 'Остановить')],
                ['campArc', iget2('b-campaigns-list', 'arhivirovat', 'Архивировать')],
                ['campUnarc', iget2('b-campaigns-list', 'razarhivirovat', 'Разархивировать')],
                ['copyCampClient', iget2('b-campaigns-list', 'kopirovat', 'Копировать')],
                ['delCamp', iget2('b-campaigns-list', 'udalit', 'Удалить')],
                ['favoriteCamp', iget2('b-campaigns-list', 'dobavit-v-samye-vazhnye', 'Добавить в самые важные')],
                ['unFavoriteCamp', iget2('b-campaigns-list', 'udalit-iz-samyh-vazhnyh', 'Удалить из самых важных')],
                ['remoderateCamp', iget2('b-campaigns-list', 'peremoderirovat', 'Перемодерировать')],
                ['editMetrikaCounters', iget2('b-campaigns-list', 'izmenit-schyotchik-metriki', 'Изменить счётчик Метрики')],
                ['ajaxSetAutoResources', iget2('b-campaigns-list', 'imzenit-videodopolneniya', 'Изменить видеодополнения')]
            ],
            massActionsValues = {},
            existTitleSup,
            showEmptyResult = true,
            ignoredFavCamps = {};

        ((!data.client_country || data.client_country == 225) && currency == 'YND_FIXED' || currency == 'RUB') &&
        massActions.push(['directPaymentInstructions', iget2('b-campaigns-list', 'popolnit-nalichnymi', 'Пополнить наличными')]);

        form.sort || (form.sort = defaultCol);
        if (sorting) {
            form.reverse || sorting.reverse && (form.reverse = sorting.reverse);
            form.settings_sorted || sorting.settings_sorted && (form.settings_sorted = sorting.settings_sorted);

            // проверяем правильный ли пришел параметр сортировки, если нет - ставим сортировку по
            // "названию"
            if (form.sort == 'settings' && !sortSettings.hash[form.settings_sorted]) {
                form.settings_sorted = '';
                form.sort = 'name';
            }
        }

        campaignsLength && campaigns.forEach(function(camp) {
            var allow_transfer_money_from_to_camp = false,
                action = camp.action || {},
                actionPay = action.pay,
                paction = camp.paction || {},
                cid = camp.cid;

            can.manager_view_others_campaigns || rights.manager_control && !action.editCamp &&
                (can.manager_view_others_campaigns = true);
            data.UID == paction.other_manager_serviced && (isMyClient = true);
            can.edit_camp || action.editCamp && (can.edit_camp = true);

            // user_allow_pay контролирует каким ролям можно работать с деньгами, а каким -- нет
            // (например, медиапланерам нельзя), второе условие нужно, чтобы клиент без
            // права переноса денег
            // не мог переносить деньги между агентскими кампаниями
            rights.user_allow_pay && !+rights.agency_disallow_money_transfer &&
                (!+camp.AgencyUID || paction.allow_transfer_money_subclient ||
                    !+rights.is_any_client) && (allow_transfer_money_from_to_camp = true);

            can.transfer_money || can.process_money_common && !camp.noaction &&
                (actionPay || allow_transfer_money_from_to_camp) && (can.transfer_money = true);

            can.payCampaign || actionPay && !camp.lowMonthShowsNoPay &&
                (can.payCampaign = true);

            can.showPayColumn || (can.showPayColumn = actionPay && !camp.noaction);

            if (auxParams && data.cmd == 'showCamps') {
                auxParams.be_shows || camp.shows && (auxParams.be_shows = true);

                // Мастер заполнения виртуальных визиток доступен только для неархивных ТГО кампаний DIRECT-68018
                auxParams.cid_for_manage_vcards ||
                    ((action.editCamp || hasLoginRights('superreader_control', 'limited_support_control')) && camp.archived == 'No' && camp.mediaType === 'text') &&
                        (auxParams.cid_for_manage_vcards = cid);

                // for show transfer money link
                allow_transfer_money_from_to_camp && (camp.total > 0 || actionPay ||
                        paction.allow_transfer_money_subclient) &&
                    !(rights.manager_control && paction.agency_serviced) &&
                    auxParams .camp_count_for_transfer++;

                // for show transfer money link
                camp.total > 0 && camp.money_type == 'real' && !(+camp.AgencyUID && rights.manager_control) &&
                    auxParams .camp_count_with_sum++;

                auxParams.exists_campaigns_for_edit || action.editCamp && (auxParams.exists_campaigns_for_edit = true);
                auxParams.show_link_manager || !camp.noaction && (auxParams.show_link_manager = true);
                auxParams.showCampStat || action.showCampStat && (auxParams.showCampStat = true);
            }

            camp.mfio = paction.other_manager_serviced_info && paction.other_manager_serviced_info.FIO || '';
            camp.afio = paction.agencys_serviced_info && paction.agencys_serviced_info.FIO || '';
            camp.mafio = form['reverse'] ?
                camp.mfio ?
                '2_' + camp.mfio :
                camp.afio ? '1_' + camp.afio : '0' :
                camp.afio ?
                '2_' + camp.afio :
                camp.mfio ? '1_' + camp.mfio : '3';

            uniqEmails[camp.email] = true;

            action.editCamp && (visibleFilter.cidsMy[cid] = true);

        }, this);

        if (splitIntoGroups) {
            campaignsLength && campaigns.forEach(function(camp) {
                var group = '3_self', // Самостоятельное обслуживание
                    agency = agenciesInfo[camp.AgencyID];

                if (camp.AgencyID != '0') {
                    group = agency && agency.freedom ?
                        '2_agency_' + camp.AgencyID : // На обслуживании агентства
                        '4_agencyold_' + camp.AgencyID; // На обслуживании агентства (обслуживание завершено)
                } else if (camp.ManagerUID) {
                    group = '1_carefree'; // На обслуживании менеджером
                }
                data.campsGroups = campsGroups;
                campsGroups[group] || (campsGroups[group] = {
                    title: apply('groupTitle', {
                        group: group,
                        agency: agency
                    }),
                    camps: [],
                    total: noTotal ? false : this.extend({}, totalTemplate),
                    groupId: group,
                    isWalletDisabled: false
                });

                if (!camp.wallet_is_enabled) {
                    campsGroups[group].isWalletDisabled = true;
                }

                campsGroups[group].camps.push(camp);
            }, this);

            !data.is_currency_archive && Object.keys(campsGroups).forEach(function(group) {
                var campaignsGroup = campsGroups[group];

                if ((group != '3_self' && group != '1_carefree') || !data.notSplitWallet &&
                    (group != '3_self' || group == '3_self' && !campsGroups['1_carefree'])) {

                    campaignsGroup.walletLink = {
                        block: 'b-wallet-link',
                        mix: [{
                            block: 'b-campaigns-list',
                            elem: 'wallet-link'
                        }],
                        content: [
                            {
                                elem: 'wallet-info'
                            },
                            {
                                elem: 'account-info',
                                mix: {
                                    block: 'b-campaigns-list',
                                    elem: 'account-info'
                                }
                            }
                        ],
                        campaigns: campaignsGroup.camps,
                        wallet: data.wallet,
                        ulogin: data.user_login,
                        currency: data.work_currency,
                        isSelfServicedGroup: group === '3_self'
                    };
                }
            }, this);

        } else {
            campsGroups['default'] = {
                camps: campaigns,
                total: noTotal ? false : this.extend({}, totalTemplate)
            };
        }
        for (group in campsGroups) {
            if (campsGroups.hasOwnProperty(group)) {
                (group != '3_self' && group != '1_carefree') && campsGroupsKeys.push(group);
            }
        }

        campsGroupsKeys.length > 1 || (splitIntoGroups = false);

        campsGroupsKeys
            .sort(function(a, b) {
                return a > b;
            });
        //DIRECT-23803 - сначала должны идти агентские кампании, а менеджерские и самостоятельные рядом
        campsGroups['1_carefree'] && campsGroupsKeys.push('1_carefree');
        campsGroups['3_self'] && campsGroupsKeys.push('3_self');

        campsGroupsKeys.forEach(function(groupId, groupIndex) {
            var group = campsGroups[groupId],
                groupCamps = group.camps,
                hideCampsCount = 0,
                // id общих счетов sum_rest для которых уже добавлен к общей сумме
                // и его не надо добавлять повторно
                addedWalletSums = {},
                visibleFlags = visibleFilter.flags;

            groupCamps.forEach(function(camp, campIndex) {
                var cid = camp.cid;

                !ignoredFavCamps[groupIndex] && (ignoredFavCamps[groupIndex] = {});

                // isHide - будет ли компания показана при текущем фильтре.
                visibleFlags.favs &&
                    (camp._isHide = !visibleFilter.cidsFav[cid]) &&
                    (ignoredFavCamps[groupIndex][campIndex] = true);
                visibleFlags.my && (camp._isHide = !visibleFilter.cidsMy[cid]);
                camp._isHide && hideCampsCount++;

                camp._totals = {};

                camp._totals['clicks'] = +camp.clicks || 0;
                noTotal || !camp._isHide && (group.total['clicks'] += camp._totals['clicks']);

                camp.day_budget2 = {
                    set: !!camp.day_budget.sum,
                    sum: camp.day_budget.sum,
                    show_mode: camp.day_budget.show_mode,
                    recommended_sum: camp.day_budget.recommended_sum
                };

                // Считаем только для тех компаний, которые показываются при текущем фильтре ;)
                if (camp.sums_uni) {
                    camp._totals['sum'] = +camp.sums_uni.sum + +(camp.sums_uni.wallet_total || 0);
                    camp._totals['sum-rest'] = +camp.sums_uni.total;

                    if (!noTotal) {
                        if (+camp.wallet_cid && !addedWalletSums[camp.wallet_cid]) {
                            addedWalletSums[camp.wallet_cid] = true;
                            group.total['sum'] += +camp.sums_uni.wallet_total;
                            group.total['sum-rest'] += +camp.sums_uni.wallet_total;
                        }

                        !camp._isHide && (group.total['sum'] += +camp.sums_uni.sum);
                        !camp._isHide &&
                            (group.total['sum-rest'] += +camp.sums_uni.sum - +camp.sums_uni.sum_spent > 0 ?
                                +camp.sums_uni.sum - +camp.sums_uni.sum_spent :
                                0);
                    }
                } else {
                    if (+camp.wallet_cid) {
                        camp._totals['sum-rest'] = +camp.wallet_total;
                        camp._totals['sum'] = +camp.sum;

                        if (!addedWalletSums[camp.wallet_cid]) {
                            addedWalletSums[camp.wallet_cid] = true;
                            noTotal || !camp._isHide && (group.total['sum-rest'] += camp._totals['sum-rest']);
                            noTotal || !camp._isHide && (group.total['sum'] += camp._totals['sum']);
                        }
                    } else {
                        camp._totals['sum-rest'] = +camp.total;
                        noTotal || !camp._isHide && (group.total['sum-rest'] += camp._totals['sum-rest']);

                        camp._totals['sum'] = +camp.sum;
                        noTotal || !camp._isHide && (group.total['sum'] += camp._totals['sum']);
                    }
                }
            });

            // Если все компании скрыты то и группу тоже скрываем.
            // showEmptyResult - скрываем 'result-empty' у элемента 'table', если видна хотя бы одна группа.
            group._isHideGroup = hideCampsCount == groupCamps.length || (showEmptyResult = false);

            if (splitIntoGroups && !noTotal) {
                for (key in commonTotal) commonTotal[key] += group.total[key];
            } else {
                commonTotal = false;
            }
        });

        can.showPayColumn && (can.showPayColumn = can.add_money);

        campaignsLength && (uniqEmails[campaigns[0].user_email] = true);
        Object.keys(uniqEmails).length > 1 && (can.show_emails = true);

        if (auxParams) {
            auxParams.payCampaign = can.payCampaign;

            if (data.cmd == 'showCamps') {
                (rights.is_any_teamleader || rights.superreader_control || rights.super_control ||
                    rights.manager_control && auxParams.show_link_manager || rights.support_control ||
                    rights.limited_support_control) &&
                agencyId && !splitIntoGroups && agenciesInfo[agencyId] &&
                    (auxParams.agencyLogin = agenciesInfo[agencyId].agency_login);

                auxParams.edit_camp = can.edit_camp;
                auxParams.transfer_money = can.transfer_money;
                auxParams.showuid = can.showuid;
                auxParams.campsExist || (auxParams.campsExist = !!campaignsLength);
            }
        }

        massActions = {
            keys: massActions.map(function(action) {
                massActionsValues[action[0]] = action[1];

                return action[0];
            }),
            values: massActionsValues
        };

        return applyNext({
            campsGroups: campsGroups,
            campsGroupsKeys: campsGroupsKeys,
            commonTotal: commonTotal,
            isMyClient: isMyClient,
            defaultCol: defaultCol,
            sortSettings: sortSettings,
            can: can,
            searchIndex: [],
            massActions: massActions,
            pageName: ctx.page,
            withSearch: withSearch,
            visibleFilter: visibleFilter,
            existTitleSup: existTitleSup,
            showEmptyResult: showEmptyResult,
            currency: currency,
            ignoredFavCamps: ignoredFavCamps,
            hasRightToSeeFavs: hasRightToSeeFavs
        });
    }),

    addJs()(function() {
        var data = this.data,
            searchIndex = this.searchIndex,
            campsGroups = this.campsGroups,
            withSearch = this.withSearch,
            noTotal = this.ctx.noTotal,
            items = [],
            needDesc = !!+data.use_camp_description,
            visibleFilter = this.visibleFilter,
            can = this.can,
            payExist = can.payCampaign && can.add_money,
            result = {
                need: {
                    search: withSearch, // поиск по кампаниям
                    massActions: can.multiedit, // блок с массовыми действиями
                    description: needDesc, // примечания
                    pay: payExist // оплата кампаний
                }
            };

        this.campsGroupsKeys.forEach(function(groupId) {
            var campsGroup = campsGroups[groupId];

            campsGroup.camps.forEach(function(camp) {
                var cid = camp.cid,
                    item = {
                        modelParams: {
                            id: cid,
                            name: u.campaign.getCampaignModelName(camp.mediaType)
                        },
                        name: camp.name,
                        cid: cid,
                        day_budget: camp.day_budget,
                        day_budget2: camp.day_budget2,
                        strategy: camp.strategy,
                        currency: camp.currency,
                        mediaType: camp.mediaType,
                        groupId: groupId.replace(/^\d*_/g, ''),
                        cost: camp.Price ||
                            data.products && data.products[camp.mediaType] && data.products[camp.mediaType].Price,
                        sumInput: data.oldsum && data.oldsum[cid] || data.FORM['oldsum_' + cid] || ''
                    };

                if (withSearch) {
                    noTotal || (item.totals = camp._totals);
                    visibleFilter.cidsFav[cid] && (item.isFav = true);
                    visibleFilter.cidsMy[cid] && (item.isMy = true);
                    needDesc && camp.camp_description && (item.desc = camp.camp_description.toLowerCase());
                }

                items.push(item);
            });
        });

        result.items = items;
        result.clientNds = data.client_nds;

        if (withSearch) {
            // Массив `searchIndex` передается внутрь по ссылке и
            // заполняется из дочерних блоков во время обработки моды `content`
            result.searchIndex = searchIndex;
        }

        withSearch && (result = this.extend(result, {
            onlyFavs: visibleFilter.flags.favs,
            onlyMy: visibleFilter.flags.my,
            mediaType: visibleFilter.flags.mediaType
        }));

        return result;
    }),

    content()(function() {
        var data = this.data,
            result = [],
            ctx = this.ctx,
            can = this.can,
            campaignsCount = +data.campaigns_count,
            perpageCount = data.onpage;

        this.withSearch && result.push({
            elem: 'filters',
            content: [
                {
                    block: 'b-selector-switch',
                    mods: {
                        action: 'mediaType'
                    },
                    mix: {
                        block: 'b-metrika2',
                        js: {
                            event: 'change',
                            params: {
                                ShowCamps: 'Campaign_type'
                            },
                            blockName: 'b-selector-switch'
                        }
                    },
                    currentOption: data.USER_OPTIONS.mediaType || 'all',
                    optionsList: u._.extend(
                        {
                            all: iget2('b-campaigns-list', 'vse-tipy-kampaniy', 'Все типы кампаний')
                        },
                        [
                            'text',
                            !!data.has_cpm_banner_campaigns && 'cpm_banner',
                            'mobile_content',
                            !!data.has_performance_campaigns && 'performance',
                            !!data.has_mcbanner_campaigns && 'mcbanner',
                            !!data.has_content_promotion_campaigns && 'content_promotion',
                            !!data.has_dynamic_campaigns && 'dynamic',
                            !!data.has_cpm_deals_campaigns && 'cpm_deals',
                            !!data.has_cpm_yndx_frontpage_campaigns && 'cpm_yndx_frontpage',
                            !!data.has_cpm_price_campaigns && 'cpm_price'
                        ].filter(Boolean).reduce(function(res, type) {
                            res[type] = {
                                block: 'b-choose-campaign-type',
                                elem: 'title',
                                elemMods: {
                                    type: u.beminize(type)
                                }
                            };

                            return res;
                        }, {})
                    )
                },
                {
                    block: 'b-search-on-list',
                    elem: 'input',
                    mix: [
                        {
                            block: 'b-campaigns-list',
                            elem: 'search-filter'
                        },

                    ],
                    hint: iget2('b-campaigns-list', 'nayti-kampaniyu', 'Найти кампанию')
                },
                data.show_favorites_filter && this.hasRightToSeeFavs && {
                    block: 'b-favorites-checkbox',
                    mix: [
                        {
                            block: 'b-campaigns-list',
                            elem: 'favorites-filter'
                        },
                        {
                            block: 'b-metrika2',
                            js: {
                                event: 'change',
                                params: {
                                    ShowCamps: 'Only_most_important'
                                },
                                blockName: 'b-favorites-checkbox'
                            }
                        }
                    ],
                    showFavOnly: data.USER_OPTIONS.show_favorite_campaigns_only == 'true'
                }
            ]
        });

        result.push({
            block: 'b-campaigns-list',
            elem: 'table',
            campaigns: ctx.campaigns || []
        });

        this.existTitleSup && result.push({
            block: 'b-campaigns-list',
            elem: 'sup-description'
        });

        (can.multiedit || can.payCampaign && can.add_money) && result.push({
            block: 'b-floater',
            mods: {
                'never-fixed': data.uatraits.isMobile || ctx.countCampaignsLists > 1 ? 'yes' : '',
                to: 'bottom'
            },
            content: {
                block: 'i-clearfix',
                content: [
                    can.multiedit && {
                        block: 'b-mass-actions',
                        mods: {
                            type: 'camps',
                            disabled: 'yes'
                        },
                        defOption: iget2('b-campaigns-list', 'vyberite-kampanii', 'Выберите кампании')
                    },
                    can.payCampaign && can.add_money && {
                        block: 'b-campaigns-list',
                        elem: 'form-pay'
                    },
                    {
                        block: 'b-campaigns-list',
                        elem: 'sum-camp',
                        content: [
                            iget2('b-campaigns-list', 'vsego-campsum', 'Всего {campSum}', {
                                campSum: {
                                    elem: 'sum-camp-pay'
                                }
                            }),
                            {
                                elem: 'sum-camp-with-nds',
                                content: [
                                    ', ',
                                    this.data.work_currency === 'BYN' ?
                                        iget2('b-campaigns-list', 'nds-20-br', 'для клиентов, которые работают с ООО «Яндекс Реклама», к счёту будет прибавлен НДС 20%') :
                                        this.data.work_currency === 'KZT' ?
                                            iget2('b-campaigns-list', 'nds-12-kz', 'для клиентов, которые работают с ТОО «Яндекс.Казахстан», к счёту будет прибавлен НДС 12%') :
                                            iget2('b-campaigns-list', 'nds-valuends-summa-platezha', 'НДС {valueNds}, Сумма платежа {campSumWithNds}', {
                                                valueNds: { elem: 'value-nds' },
                                                campSumWithNds: { elem: 'sum-camp-pay-with-nds' }
                                            })
                                ]
                            }
                        ]
                    }
                ]
            }
        });

        if (!ctx.dontDrawPages) {
            data.pages_num > 1 && data.page != 'all' && result.push({
                block: 'b-pager',
                currentPage: +data.page,
                pageParam: 'page',
                startFrom: 1,
                totalCount: campaignsCount,
                perpageCount: perpageCount,
                pageUrl: u.formatUrl({
                    host: data.script,
                    query: u.getUrlParams(['page'])
                }),
                content: [
                    {
                        elem: 'title',
                        content: iget2('b-campaigns-list', 'stranicy', 'Страницы')
                    },
                    {
                        elem: 'button-prev',
                        content: iget2('b-campaigns-list', 'predydushchaya', 'предыдущая')
                    },
                    {
                        elem: 'button-next',
                        content: iget2('b-campaigns-list', 'sleduyushchaya', 'следующая')
                    },
                    {
                        elem: 'pages',
                        showFirst: true,
                        showLast: true
                    }
                ]
            });

            if (!ctx.noPerpageSelector && campaignsCount > 100) {
                var pages = {
                        100: 100,
                        500: 500,
                        1000: 1000
                    },
                    perpageCountExistInPages = false;

                for (var key in pages) {
                    if (pages.hasOwnProperty(key) && perpageCount == pages[key]) {
                        perpageCountExistInPages = true;
                        break;
                    }
                }

                perpageCountExistInPages || (pages[perpageCount] = perpageCount);

                result.push({
                    block: 'b-perpage-selector',
                    pages: pages,
                    url: u.formatUrl({
                        host: data.script,
                        query: u.getUrlParams(['page', 'onpage'])
                    }),
                    onpage: perpageCount,
                    content: iget2('b-campaigns-list', 'pokazyvat-pagesselector-kampaniy-na', 'Показывать {pagesSelector} кампаний на странице', {
                        pagesSelector: {
                            elem: 'pages-selector'
                        }
                    })
                });
            }
        }

        this.withSearch && can.manager_view_others_campaigns && result.push({
            block: 'b-selector-switch',
            mods: {
                size: 's',
                action: 'my'
            },
            mix: [{
                block: 'b-metrika2',
                js: {
                    event: 'change',
                    params: {
                        ShowCamps: 'showOnlyMyCampaignsFilterChange'
                    },
                    blockName: 'b-selector-switch'
                }
            }],
            currentOption: this.data.USER_OPTIONS.show_my_campaigns_only == 'true' ? 'my' : 'all',
            optionsList: {
                all: iget2('b-campaigns-list', 'pokazat-nedostupnye-kampanii', 'Показать недоступные кампании'),
                my: iget2('b-campaigns-list', 'skryt-nedostupnye-kampanii', 'Скрыть недоступные кампании')
            }
        });

        result.push({
            block: 'b-description-popup',
            mix: [
                {
                    block: 'b-campaigns-list',
                    elem: 'description-popup'
                },
                {
                    block: 'b-metrika2',
                    js: {
                        event: 'save-click',
                        params: {
                            ShowCamps: {
                                Comments: {
                                    Popup: 'Save'
                                }
                            }
                        },
                        blockName: 'b-description-popup'
                    }
                }
            ],
            jsOptions: {
                cmd: 'ajaxSaveCampDescription',
                ulogin: data.FORM.ulogin
            }
        });

        return result;
    }),

    mode('getSortSettings')(function() {
        var isChangeManualStrategyName = Boolean(this.data.has_change_name_bid_optimization);

        var hash = {},
            arr = u._.compact([
                {
                    value: 'dontShowYacontext',
                    name: iget2('b-campaigns-list', 'str-seti-podklyucheny', '{str} подключены', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'str-seti-podklyucheny-param-str', 'Сети')),

                        context: 'str - Сети'
                    }),
                    title: iget2('b-campaigns-list', 'seti-130', 'Сети'),
                    full: iget2('b-campaigns-list', 'seti-podklyucheny', 'сети подключены')
                },
                {
                    value: 'sDefault',
                    name: iget2('b-campaigns-list', 'strategiya-str-ruchnoe-upravlenie', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(isChangeManualStrategyName ? iget2('b-campaigns-list', 'strategiya-str-ruchnoe-upravlenie-param-str3', 'ручное управление (с оптимизацией)') : iget2('b-campaigns-list', 'strategiya-str-ruchnoe-upravlenie-param-str2', 'ручное управление<br/>(с оптимизацией в сетях)')
                        ),

                        context: 'str - ручное управление'
                    }),
                    // этот текст переопределяется при выводе в блоке b-campaigns-list-item - DIRECT-85248
                    title: isChangeManualStrategyName ? iget2('b-campaigns-list', 'ruchnoe-upravlenie3', 'Ручное управление (с оптимизацией)') : iget2('b-campaigns-list', 'ruchnoe-upravlenie2', 'Ручное управление<br/>(с оптимизацией в сетях)'),
                    full: isChangeManualStrategyName ? iget2('b-campaigns-list', 'strategiya-ruchnoe-upravlenie3', 'стратегия ручное управление (с оптимизацией)') : iget2('b-campaigns-list', 'strategiya-ruchnoe-upravlenie2', 'стратегия ручное управление<br/>(с оптимизацией в сетях)'),
                    isAbsentSoft: true
                },
                {
                    value: 'sOptimizeClicksAvgClick',
                    name: iget2('b-campaigns-list', 'strategiya-str', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'optimize-clicks-avg-click', 'оптимизация кликов<br/>(ср. цена клика)')),

                        context: 'str - ср. цена клика'
                    }),
                    title: iget2('b-campaigns-list', 'optimize-clicks-avg-click-2', 'Оптимизация кликов (ср. цена клика)'),
                    full: iget2('b-campaigns-list', 'optimize-clicks-avg-click-strategy', 'стратегия оптимизация кликов (средняя цена клика)'),
                    isAbsentSoft: true,
                    large: true
                },
                {
                    value: 'sOptimizeClicksWeekBudget',
                    name: iget2('b-campaigns-list', 'strategiya-str', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'optimize-clicks-weekly-budget', 'оптимизация кликов (недельный бюджет)')),
                    }),
                    title: iget2('b-campaigns-list', 'optimize-clicks-weekly-budget-2', 'Оптимизация кликов (недельный бюджет)'),
                    full: iget2('b-campaigns-list', 'optimize-clicks-weekly-budget-strategy', 'стратегия оптимизация кликов (недельный бюджет)'),
                    isAbsentSoft: true
                },
                {
                    value: 'sOptimizeClicksWeekBundle',
                    name: iget2('b-campaigns-list', 'strategiya-str', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'optimize-clicks-weekly-bundle', 'оптимизация кликов (пакет кликов)')),
                    }),
                    title: iget2('b-campaigns-list', 'optimize-clicks-weekly-bundle-2', 'Оптимизация кликов (пакет кликов)'),
                    full: iget2('b-campaigns-list', 'optimize-clicks-weekly-bundle-strategy', 'стратегия оптимизация кликов (пакет кликов)'),
                    isAbsentSoft: true
                },
                {
                    value: 'sOptimizeCpaAvgCpa',
                    name: iget2('b-campaigns-list', 'strategiya-str', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'optimize-cpa-avg-cpa', 'оптимизация конверсий<br/>(ср. цена конверсии)')),
                    }),
                    title: iget2('b-campaigns-list', 'optimize-cpa-avg-cpa-2', 'Оптимизация конверсий (ср. цена конверсии)'),
                    full: iget2('b-campaigns-list', 'optimize-cpa-avg-cpa-strategy', 'стратегия оптимизация конверсий (средняя цена конверии)'),
                    isAbsentSoft: true,
                    large: true
                },
                {
                    value: 'sOptimizeCpaWeekBudget',
                    name: iget2('b-campaigns-list', 'strategiya-str', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'optimize-cpa-weekly-budget', 'оптимизация конверсий<br/>(недельный бюджет)')),
                    }),
                    title: iget2('b-campaigns-list', 'optimize-cpa-weekly-budget-2', 'Оптимизация конверсий (недельный бюджет)'),
                    full: iget2('b-campaigns-list', 'optimize-cpa-weekly-budget-strategy', 'стратегия оптимизация конверсий (недельный бюджет)'),
                    isAbsentSoft: true,
                    large: true
                },
                {
                    value: 'sAutobudgetRoi',
                    name: iget2('b-campaigns-list', 'strategiya-str-rentabelnost-investiciy', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'optimize-roi', 'оптимизация рентабельности')),

                        context: 'str - рентабельность инвестиций'
                    }),
                    title: iget2('b-campaigns-list', 'optimize-roi-2', 'Оптимизация рентабельности'),
                    full: iget2('b-campaigns-list', 'optimize-roi-strategy', 'стратегия оптимизация рентабельности'),
                    isAbsentSoft: true
                },
                {
                    value: 'sAutobudgetMaxReach',
                    name: iget2('b-campaigns-list', 'strategiya-str-snizhenie-ceny-weekly', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'strategiya-str-snizhenie-ceny-weekly-param-str', 'снижение цены повторных показов<br/>(недельный бюджет)')),

                        context: 'str - снижение цены повторных показов'
                    }),
                    title: iget2('b-campaigns-list', 'snizhenie-ceny-povtornyh-pokazov-weekly', 'Снижение цены повторных показов (недельный бюджет)'),
                    full: iget2('b-campaigns-list', 'strategiya-snizhenie-ceny-povtornyh-weekly', 'стратегия снижение цены повторных показов (недельный бюджет)'),
                    isAbsentSoft: true,
                    large: true
                },
                {
                    value: 'sAutobudgetMaxReachCustomPeriod',
                    name: iget2('b-campaigns-list', 'strategiya-str-snizhenie-ceny-period', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'strategiya-str-snizhenie-ceny-period-param-str', 'снижение цены повторных показов<br/>(бюджет на период)')),

                        context: 'str - снижение цены повторных показов'
                    }),
                    title: iget2('b-campaigns-list', 'snizhenie-ceny-povtornyh-pokazov-period', 'Снижение цены повторных показов (бюджет на период)'),
                    full: iget2('b-campaigns-list', 'strategiya-snizhenie-ceny-povtornyh-period', 'стратегия снижение цены повторных показов (бюджет на период)'),
                    isAbsentSoft: true,
                    large: true
                },
                {
                    value: 'sAutobudgetAvgCpv',
                    name: iget2('b-campaigns-list', 'strategiya-str-oplata-za-prosmotru-weekly', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'strategiya-str-oplata-za-prosmotru-weekly-param-str', 'оплата за просмотры<br/>(недельный бюджет)')),

                        context: 'str - оплата за просмотры'
                    }),
                    title: iget2('b-campaigns-list', 'oplata-za-prosmotru-weekly', 'Оплата за просмотры (недельный бюджет)'),
                    full: iget2('b-campaigns-list', 'strategiya-oplata-za-prosmotru-weekly', 'стратегия оплата за просмотры (недельный бюджет)'),
                    isAbsentSoft: true,
                    large: true
                },
                {
                    value: 'sAutobudgetAvgCpvCustomPeriod',
                    name: iget2('b-campaigns-list', 'strategiya-str-oplata-za-prosmotru-period', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'strategiya-str-oplata-za-prosmotru-period-param-str', 'оплата за просмотры<br/>(бюджет на период)')),

                        context: 'str - оплата за просмотры'
                    }),
                    title: iget2('b-campaigns-list', 'oplata-za-prosmotru-period', 'Оплата за просмотры (бюджет на период)'),
                    full: iget2('b-campaigns-list', 'strategiya-oplata-za-prosmotru-period', 'стратегия оплата за просмотры (бюджет на период)'),
                    isAbsentSoft: true,
                    large: true
                },
                {
                    value: 'sAutobudgetMaxImpressions',
                    name: iget2('b-campaigns-list', 'strategiya-str-maksimum-pokazov-weekly', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'strategiya-str-maksimum-pokazov-weekly-param-str', 'максимум показов по минимальной цене<br/>(недельный бюджет)')),

                        context: 'str - максимум показов по минимальной цене (недельный бюджет)'
                    }),
                    title: iget2('b-campaigns-list', 'maksimum-pokazov-weekly-po-minimalnoy', 'Максимум показов по минимальной цене (недельный бюджет)'),
                    full: iget2('b-campaigns-list', 'strategiya-maksimum-pokazov-weekly-po', 'стратегия максимум показов по минимальной цене (недельный бюджет)'),
                    isAbsentSoft: true,
                    large: true
                },
                {
                    value: 'sAutobudgetMaxImpressionsCustomPeriod',
                    name: iget2('b-campaigns-list', 'strategiya-str-maksimum-pokazov-period', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'strategiya-str-maksimum-pokazov-period-param-str', 'максимум показов по минимальной цене<br/>(бюджет на период)')),

                        context: 'str - максимум показов по минимальной цене (бюджет на период)'
                    }),
                    title: iget2('b-campaigns-list', 'maksimum-pokazov-period-po-minimalnoy', 'Максимум показов по минимальной цене (бюджет на период)'),
                    full: iget2('b-campaigns-list', 'strategiya-maksimum-pokazov-period-po', 'стратегия максимум показов по минимальной цене (бюджет на период)'),
                    isAbsentSoft: true,
                    large: true
                },
                {
                    value: 'sPeriodFixBid',
                    name: iget2('b-campaigns-list', 'strategiya-str-maksimum-pokazov-period', 'Стратегия: {str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'strategiya-fixing-cpm-str', 'фиксированный CPM')),

                        context: 'str - фиксированный CPM'
                    }),
                    title: iget2('b-campaigns-list', 'fixing-cpm', 'Фиксированный СРМ'),
                    full: iget2('b-campaigns-list', 'strategiya-fixing-cpm', 'стратегия фиксированный CPM'),
                    isAbsentSoft: true,
                    large: true
                },
                {
                    value: 'sDifferentPlaces',
                    name: iget2('b-campaigns-list', 'str-upravlenie-pokazami-v', '{str}', {
                        str: function(text) {
                            return {
                                tag: 'strong',
                                content: text
                            };
                        }(iget2('b-campaigns-list', 'str-upravlenie-pokazami-v-param-str', 'Управление показами в сетях')),

                        context: 'str - Управление показами в сетях'
                    }),
                    title: iget2('b-campaigns-list', 'upravlenie-pokazami-v-setyah', 'Управление показами в сетях'),
                    full: iget2('b-campaigns-list', 'upravlenie-pokazami-v-setyah-132', 'управление показами в сетях'),
                    isAbsentSoft: true
                }
            ]);
        u.consts('rights').useDynamicMediaCampaigns && arr.push({
            value: 'sAutobudgetAvgCPCPerCamp',
            name: iget2('b-campaigns-list', 'strategiya-str-opt-kol', 'Стратегия: {str}', {
                str: function(text) {
                    return {
                        tag: 'strong',
                        content: text
                    };
                }(iget2('b-campaigns-list', 'strategiya-str-opt-kol-param-str', 'опт. кол. кликов на всю кампанию')),

                context: 'str - опт. кол. кликов на всю кампанию'
            }),
            title: iget2('b-campaigns-list', 'cpc-na-vsyu-kampaniyu', 'CPC на всю кампанию'),
            full: iget2(
                'b-campaigns-list',
                'strategiya-optimizaciya-kolichestva-klikov',
                'стратегия оптимизация количества кликов на всю кампанию'
            ),
            isAbsentSoft: true
        }, {
            value: 'sAutobudgetAvgCPCPerFilter',
            name: iget2('b-campaigns-list', 'strategiya-str-opt-kol-133', 'Стратегия: {str}', {
                str: function(text) {
                    return {
                        tag: 'strong',
                        content: text
                    };
                }(iget2('b-campaigns-list', 'strategiya-str-opt-kol-133-param-str', 'опт. кол. кликов на каждый фильтр')),

                context: 'str - опт. кол. кликов на каждый фильтр'
            }),
            title: iget2('b-campaigns-list', 'cpc-na-kazhdyy-filtr', 'CPC на каждый фильтр'),
            full: iget2(
                'b-campaigns-list',
                'strategiya-optimizaciya-kolichestva-klikov-134',
                'стратегия оптимизация количества кликов на каждый фильтр'
            ),
            isAbsentSoft: true
        }, {
            value: 'sAutobudgetAvgCPAPerCamp',
            name: iget2('b-campaigns-list', 'strategiya-str-opt-kol-135', 'Стратегия: {str}', {
                str: function(text) {
                    return {
                        tag: 'strong',
                        content: text
                    };
                }(iget2('b-campaigns-list', 'strategiya-str-opt-kol-135-param-str', 'опт. кол. конверсий на всю кампанию')),

                context: 'str - опт. кол. конверсий на всю кампанию'
            }),
            title: iget2('b-campaigns-list', 'cpa-na-vsyu-kampaniyu', 'CPA на всю кампанию'),
            full: iget2(
                'b-campaigns-list',
                'strategiya-optimizaciya-kolichestva-konversiy',
                'стратегия оптимизация количества конверсий на всю кампанию'
            ),
            isAbsentSoft: true
        }, {
            value: 'sAutobudgetAvgCPAPerFilter',
            name: iget2('b-campaigns-list', 'strategiya-str-opt-kol-136', 'Стратегия: {str}', {
                str: function(text) {
                    return {
                        tag: 'strong',
                        content: text
                    };
                }(iget2('b-campaigns-list', 'strategiya-str-opt-kol-136-param-str', 'опт. кол. конверсий на каждый фильтр')),

                context: 'str - опт. кол. конверсий на каждый фильтр'
            }),
            title: iget2('b-campaigns-list', 'cpa-na-kazhdyy-filtr', 'CPA на каждый фильтр'),
            full: iget2(
                'b-campaigns-list',
                'strategiya-optimizaciya-kolichestva-konversiy-137',
                'стратегия оптимизация количества конверсий на каждый фильтр'
            ),
            isAbsentSoft: true
        });

        arr.push({
            value: 'broad_match_flag',
            name: iget2('b-campaigns-list', 'vklyucheny-pokazy-po-str', 'Включены показы по {str}', {
                str: function(text) {
                    return {
                        tag: 'strong',
                        content: text
                    };
                }(iget2('b-campaigns-list', 'vklyucheny-pokazy-po-str-param-str', 'доп. фразам')),

                context: 'str - доп. фразам'
            }),
            title: iget2('b-campaigns-list', 'dop-frazy', 'Доп. фразы'),
            full: iget2('b-campaigns-list', 'vklyucheny-pokazy-po-dop', 'включены показы по доп. фразам')
        }, {
            value: 'statusOpenStat',
            name: iget2('b-campaigns-list', 'podklyuchena-metka-str-openstat', 'Подключена метка {str}', {
                str: function(text) {
                    return {
                        tag: 'strong',
                        content: text
                    };
                }(iget2('b-campaigns-list', 'podklyuchena-metka-str-openstat-param-str', 'OpenStat')),

                context: 'str - OpenStat'
            }),
            title: iget2('b-campaigns-list', 'openstat', 'OpenStat'),
            full: iget2('b-campaigns-list', 'podklyuchena-metka-openstat', 'подключена метка OpenStat')
        }, {
            value: 'DontShow',
            name: iget2('b-campaigns-list', 'ukazany-str-zapreshchennye-ploshchadki', 'Указаны {str}', {
                str: function(text) {
                    return {
                        tag: 'strong',
                        content: text
                    };
                }(iget2('b-campaigns-list', 'ukazany-str-zapreshchennye-ploshchadki-param-str', 'запрещенные площадки и внешние сети')),

                context: 'str - запрещенные площадки и внешние сети'
            }),
            title: iget2('b-campaigns-list', 'zapreshch-pl', 'Запрещ. пл.'),
            full: iget2('b-campaigns-list', 'ukazany-zapreshchennye-ploshchadki-i', 'указаны запрещенные площадки и внешние сети'),
            isAbsent: true
        }, {
            value: 'statusMetricaControl',
            name: iget2('b-campaigns-list', 'vklyuchen-str-monitoring-sayta', 'Включен {str}', {
                str: function(text) {
                    return {
                        tag: 'strong',
                        content: text
                    };
                }(iget2('b-campaigns-list', 'vklyuchen-str-monitoring-sayta-param-str', 'мониторинг сайта')),

                context: 'str - мониторинг сайта'
            }),
            title: iget2('b-campaigns-list', 'monitoring-sayta', 'Мониторинг сайта'),
            full: iget2('b-campaigns-list', 'vklyuchen-monitoring-sayta', 'включен мониторинг сайта'),
            isAbsent: true
        }, {
            value: 'disabledIps',
            name: iget2('b-campaigns-list', 'ukazany-str-zapreshchyonnye-ip', 'Указаны {str}', {
                str: function(text) {
                    return {
                        tag: 'strong',
                        content: text
                    };
                }(iget2('b-campaigns-list', 'ukazany-str-zapreshchyonnye-ip-param-str', 'запрещённые IP')),

                context: 'str - запрещённые IP'
            }),
            title: iget2('b-campaigns-list', 'zapret-po-ip', 'Запрет по IP'),
            full: iget2('b-campaigns-list', 'ukazany-zapreshchennye-ip', 'указаны запрещенные IP'),
            isAbsent: true
        });

        arr.forEach(function(item, i) {
            hash[item.value] = this.extend(item, {
                pos: i
            });
        }, this);

        return {
            arr: arr,
            hash: hash
        };
    }),

    mode('groupTitle')(function() {
        var group = this.group,
            agency = this.agency;

        if (group == '1_carefree') {
            return iget2('b-campaigns-list', 'na-obsluzhivanii-menedzherom', 'На обслуживании менеджером');
        }

        if (group == '3_self') {
            return iget2('b-campaigns-list', 'samostoyatelno', 'Самостоятельно');
        }

        var result = [],
            name = {
                elem: 'heading-title',
                elemMods: !agency.freedom ? { closed: 'yes' } : '',
                content: agency.agency_name
            };

        agency.agency_url && (name = {
            block: 'link',
            url: 'http://' + agency.agency_url,
            mix: [this.extend(name, {
                content: ''
            })],
            content: name.content
        });

        result.push(iget2('b-campaigns-list', 'agentstvo-name', 'Агентство «{name}»', {
            name: name
        }));

        agency.freedom || result.push({
            elem: 'heading-note',
            content: iget2('b-campaigns-list', 'obsluzhivanie-reklamnyh-kampaniy-zaversheno', 'обслуживание рекламных кампаний завершено')
        });

        return result;
    }),

    mode('can')(function() {
        var pageName = this.ctx.page,
            data = this.data,
            rights = data.login_rights,
            form = data.FORM,
            isArchive = data.is_currency_archive,
            controlManagerSuperPlacer = rights.manager_control || rights.super_control || rights.placer_control,
            can_process_money_common = !isArchive && pageName != 'search-by-date' && pageName != 'search' &&
            pageName != 'reports-scamps' && pageName != 'search-for-agency' && form.tab != 'arch' &&
            !rights.placer_control,
            see_owner = pageName == 'search-by-date' || pageName == 'search' ||
            ((this.data.can.see_original_sum || rights.agency_control) && pageName != 'campaigns');

        return {
            transfer_money: false,
            process_money_common: can_process_money_common,
            add_money: can_process_money_common && !+rights.agency_limited_no_pay,
            multiedit: data.cmd === 'showCamps' && !isArchive,
            see_owner: see_owner,
            see_manager: data.UID != data.uid || controlManagerSuperPlacer || pageName == 'search' ||
                pageName == 'search-for-agency',
            see_favorites: rights.is_any_client || rights.manager_control || rights.agency_control ||
                rights.super_control || rights.support_control,
            edit_camp: false,
            showuid: data.UID != data.uid ||
                /^search|search-by-date|reports-scamps|campaigns-subclient|search\-for\-agency$/.test(pageName),
            show_emails: false,
            manager_view_others_campaigns: false,
            showPayColumn: false // есть ли хоть один инпут для оплаты
        };
    })
);
