(function() {

    var MODEL = BEM.MODEL,
        blocks = BEM.blocks,
        confirm = blocks['b-confirm'],
        bPage = blocks['b-page'].getInstance();

    BEM.DOM.decl({ block: 'b-campaigns-list', baseBlock: 'b-data-list' }, {

        onSetMod: {

            js: function() {
                var params = this.params,
                    need = params.need,
                    searchIndex = params.searchIndex,
                    ignoreCampsOnInit = this.elemParams('table').ignoredCamps,
                    dataForSearch,
                    bCamps,
                    _onCountSumPriceDebounce = $.debounce(this._onCountSumPrice, 100);

                //объект с моделями кампаний
                this._campModelsHash = {};
                //id кампаний
                this._campsCidsToPay = [];

                if (need.search) {
                    dataForSearch = [];
                    bCamps = this.findElem(this.elem('group'), 'row');
                }

                params.items.forEach(function(item, i) {
                    var groupId = item.groupId,
                        strategy = item.strategy,
                        model;

                    typeof strategy == 'string' && (strategy = { name: strategy });

                    need.search && (dataForSearch[i] = {
                        searchIndex: searchIndex[i],
                        desc: item.desc || '',
                        totals: item.totals,
                        mediaType: item.mediaType,
                        isFav: item.isFav,
                        isMy: item.isMy,
                        domElem: bCamps.eq(i),
                        groupId: groupId
                    });

                    model = MODEL.create(item.modelParams, {
                        cid: item.cid,
                        day_budget2: item.day_budget2,
                        name: item.name,
                        strategy: strategy,
                        strategy_name: strategy && strategy.name,
                        search_strategy: strategy && strategy.search && strategy.search.name,
                        net_strategy: strategy && strategy.net && strategy.net.name,
                        currency: item.currency,
                        groupId: groupId,
                        mediaType: item.mediaType,
                        sumInput: item.sumInput,
                        //@heliarian нужно для правильной работы на баяне
                        cost: item.cost,
                        nds: item.nds
                    });

                    model.on('sumInput', 'change', _onCountSumPriceDebounce, this);

                    this._campModelsHash[item.cid] = model;

                }, this);
                need.search && this
                    .initRecountTableWidths()
                    .initSearch(dataForSearch, 'camps', {
                        onlyFavs: params.onlyFavs,
                        onlyMy: params.onlyMy,
                        mediaType: params.mediaType
                    });

                need.massActions && this.initMassActions();

                need.description && this.initDescriptions();

                if (need.pay) {
                    // принудительно инициализируем блоки 'b-campaigns-list-item' с указанными значениями
                    this.findBlocksOn('row', { block: 'b-campaigns-list-item', modName: 'init', modVal: 'force' });

                    this._showYaMoneyButton();

                    this._getPayButtons().forEach(function(payButton) {
                        payButton.on('click', this._onValidationForm, this);
                    }, this);
                }

                this._campsListItems = this.findBlocksInside('b-campaigns-list-item');

                Object.keys(ignoreCampsOnInit).length && this._setIgnoredCamps(ignoreCampsOnInit);

                //запускаем заполнение _campsCidsToPay и актуализируем дисаблинг кнопок оплаты, на случай, если на момент загрузки поля ввода уже заполненны данными
                //(например при возвращении на страницу списка кампаниий с ошибкой)
                this._onCountSumPrice();
            }

        },

        /* Поиск */

        /**
         * @private
         * @type {Boolean}
         */
        _onlyFavs: null,

        /**
         * @private
         * @type {Boolean}
         */
        _onlyMy: null,

        /**
         * @private
         * @type {Object}
         */
        _lastQuery: {},

        /**
         * Инициализация поиска
         * @param {Object} [items] Данные для поиска
         * @param {String} items.searchIndex
         * @param {String} items.desc
         * @param {Object} items.totals
         * @param {Boolean} items.isFav
         * @param {Boolean} items.isMy
         * @param {jQuery} items.domElem
         * @param {Boolean} [type] Имя модификатора type
         * @param {Object} params
         *  @param {Boolean} params._onlyFavs поиск исключает не избранные
         *  @param {Boolean} params._onlyMy поиск исключает не собственные кампании
         */
        initSearch: function(items, type, params) {
            this.__base.apply(this, arguments);
            var favoriteCbx = bPage.findBlockInside('b-favorites-checkbox');

            favoriteCbx && favoriteCbx.on('change', function(e, data) {
                var iUserOptions = blocks['i-user-options'];

                iUserOptions.set('show_favorite_campaigns_only', this._onlyFavs = data && data.isChecked);
                this.search({ text: this._lastQuery.text || '' });
            }, this);

            this._onlyFavs = params.onlyFavs;
            this._onlyMy = params.onlyMy;
            this._mediaType = params.mediaType;

            bPage.findBlocksInside('b-selector-switch').forEach(function(bSelectorSwitch) {
                bSelectorSwitch.on(
                    'change',
                    { action: bSelectorSwitch.getMod('action') },
                    this._onSelectorSwitch,
                    this);
                // инициируем текущие значения, если они есть
                bSelectorSwitch.initDefault();
            }, this);

            return this;
        },

        /**
         * Метод поиска
         * @param {Object} query
         *  @param {String} query.text строка поиска
         *  @param {Boolean} query._onlyFavs поиск исключает не избранные
         *  @param {Boolean} query._onlyMy поиск исключает не собственные кампании
         */
        search: function(query) {
            query.onlyFavs = this._onlyFavs;
            query.onlyMy = this._onlyMy;
            query.mediaType = this._mediaType;

            if (query.text == this._lastQuery.text && query.onlyFavs == this._lastQuery.onlyFavs &&
                query.onlyMy == this._lastQuery.onlyMy && query.mediaType == this._lastQuery.mediaType) {
                return;
            }

            this._lastQuery = query;

            this.__base.apply(this, arguments);
        },

        /**
         * @private
         * @type {Object}
         */
        _campNumberByGroupId: null,

        /**
         * Обработчик события начала поиска
         * @private
         */
        _onSearchStart: function() {
            this._campNumberByGroupId = {};
        },

        /**
         * Обработчик события совпадения
         * Устанавливаем порядковый номер компании в группе
         * @private
         * @param {jQuery.Event} [e]
         * @param {Object} [data]
         *  @param {Object} data.item найденный элемент
         *  @param {Object} data.iterator итератор поиска
         */
        _onSearchFound: function(e, data) {
            var item = data.item,
                groupId = item.groupId;

            this._campNumberByGroupId[groupId] || (this._campNumberByGroupId[groupId] = 1);

            this._getNumberNode(item.domElem, data.iterator.iteration).text(this ._campNumberByGroupId[groupId]++);

            this.__base.apply(this, arguments);
        },

        /**
         * Обработчик события окончания поиска
         * Прячем группы без кампаний и пересчитываем Всего/Итого
         * @private
         * @param {jQuery.Event} [e]
         * @param {Object} [data]
         *  @param {Object} data.iterator итератор поиска
         */
        _onSearchFinish: function(e, data) {
            this.__base.apply(this, arguments);

            var _this = this,
                countVisibleGroup = 0,
                allTotals = [],
                visibleMap = data.iterator.visibleMap;

            _this.elem('group').each(function(index, group) {
                var $group = $(group),
                    total,
                    range = _this.elemParams($group),
                    visibleIndexesInGroup = [];

                for (var i = range.from; i < range.to; i++) {
                    (visibleMap[i] && visibleIndexesInGroup.push(i));
                }

                visibleIndexesInGroup.length && (countVisibleGroup += 1);

                total = _this.getSearchable().getTotals(visibleIndexesInGroup);
                allTotals.push(total);

                _this
                    .setMod($group, 'hidden', visibleIndexesInGroup.length ? '' : 'yes')
                    .updateTotal($group, index, total);
            });

            _this
                .setMod(_this.elem('total', 'common', 'yes'), 'hidden', countVisibleGroup > 1 ? '' : 'yes')
                .setMod(_this.elem('result-empty'), 'hidden', countVisibleGroup ? 'yes' : '')
                .updateCommonTotal(allTotals);
        },

        /**
         * @private
         * @type {Array}
         */
        _numberNodeChache: null,

        /**
         * Возвращает элемент 'number'
         * @param {jQuery} domElem DOM-нода строки
         * @param {Number} index index среди всех элементов 'number'
         * @returns {jQuery}
         */
        _getNumberNode: function(domElem, index) {
            this._numberNodeChache || (this._numberNodeChache = []);

            return this._numberNodeChache[index] || (this._numberNodeChache[index] = this.findElem(domElem, 'number'));
        },

        /**
         * Обработчик переключения фильтров
         * @private
         * @param {jQuery.Event} [e]
         * @param {Object} [data]
         * @param {String} data.optionName идентификатор выбранной опции
         */
        _onSelectorSwitch: function(e, data) {
            var iUserOptions = blocks['i-user-options'];

            if (e.data.action == 'mediaType') {
                this._mediaType = data;
                iUserOptions.set('mediaType', data);
            } else {
                iUserOptions.set('show_my_campaigns_only', this._onlyMy = data == 'my');
            }

            this.search({ text: this._lastQuery.text || '' });
        },

        /**
         * Обновляет значения Итого
         * @param {jQuery} group DOM-нода группы
         * @param {Number} index index Группы
         * @param {Object} total объект с пересчитанными суммами
         */
        updateTotal: function(group, index, total) {
            this._getCampaignsNumeric(group, index).forEach(function(bCampNumeric) {
                bCampNumeric.val(total[bCampNumeric.getMod('type')]);
            });
        },

        /**
         * @private
         * @type {Object}
         */
        _cacheCampaignsNumeric: {},

        /**
         * Возвращает экземпляры блока 'b-list-numeric' в группе
         * @private
         * @param {jQuery} [group] DOM-нода группы
         * @param {Number|String} [index='common']
         * @returns {BEM[]}
         */
        _getCampaignsNumeric: function(group, index) {
            index == undefined && (index = 'common');

            if (!this._cacheCampaignsNumeric[index]) {
                this._cacheCampaignsNumeric[index] = this.findBlocksInside(
                    index == 'common' ? this.elem('total', 'common', 'yes') : this.findElem(group, 'total'),
                    'b-list-numeric');
            }

            return this._cacheCampaignsNumeric[index];
        },

        /**
         * Обновляет значения 'Всего' (общая сумма по всем группам)
         * @param {Object[]} allTotals массив в объектами с пересчитанными суммами
         */
        updateCommonTotal: function(allTotals) {
            var resTotals = allTotals[0];

            allTotals.slice(1).forEach(function(totals) {
                for (var field in resTotals) resTotals[field] += totals[field];
            });

            this._getCampaignsNumeric().forEach(function(bCampNumeric) {
                bCampNumeric.val(resTotals[bCampNumeric.getMod('type')]);
            });
        },

        /* END Поиск */

        /* Оплата кампаний */

        /**
         * Обновляем список кампаний, для которых пользователь ввел сумму оплаты
         * @private
         */
        _updateCampsCidsToPayList: function() {
            this._campsCidsToPay = Object.keys(this._campModelsHash)
                .filter(function(cid) {
                    var model = this._campModelsHash[cid];

                    return typeof model.get('sumInput') !== 'undefined' &&
                        !model.isEmpty('sumInput') &&
                        model.validate('sumInput').valid;
                }, this)
        },

        /**
         * Изменение поля sumInput на модели кампании
         * валидирует цены при вводе, дизейблит кнопку «Оплатить»
         * @param {Event} e
         * @param {Object} data
         * @private
         */
        _onCountSumPrice: function(e, data) {
            var groupIds = [],
                groupLength,
                filteredGroupIds;

            this._updateCampsCidsToPayList();

            this._campsCidsToPay.forEach(function(cid) {
                var groupId = this._campModelsHash[cid].get('groupId');

                if (groupIds.indexOf(groupId) == -1) groupIds.push(groupId);
            }, this);

            filteredGroupIds = groupIds.filter(function(groupId) {
                return 'carefree self'.indexOf(groupId) != -1
            }).length;

            groupLength = groupIds.length;

            if (groupLength > 1 && groupLength != filteredGroupIds) {

                confirm.alert(iget2(
                    'b-campaigns-list',
                    'vy-ne-mozhete-odnovremenno',
                    'Вы не можете одновременно оплачивать кампании с разным типом обслуживания'
                ));

                return;
            }

            this._toggleDisabledPayButtons(!groupLength);

            this._updateTotalSum();
        },

        /**
         * Возвращает НДС
         * @returns {Number}
         * @private
         */
        _getClientNds: function() {
            //clientNds приходит в процентах
            return this.params.clientNds ? this.params.clientNds / 100 : 0;
        },

        /**
         * Обновляем текст в футере с итоговой суммой
         * @private
         */
        _updateTotalSum: function() {
            var totalSum = 0,
                clientNds = this._getClientNds(),
                totalSumWithNds,
                currency;

            this._campsCidsToPay.forEach(function(cid) {
                totalSum = totalSum + this._campModelsHash[cid].get('sumInput');
                //во всех кампаниях клиента валюта одинаковая
                !currency && (currency = this._campModelsHash[cid].get('currency'));
            }, this);

            totalSumWithNds = clientNds * totalSum + totalSum;

            this.elem('sum-camp-pay').html(u.currencies.formatSum(currency, totalSum));
            this.elem('value-nds').html(clientNds * 100 + '%');
            this.elem('sum-camp-pay-with-nds').html(u.currencies.formatSum(currency, totalSumWithNds));
            this.setMod(this.elem('sum-camp'), 'visible', totalSum > 0 ? 'yes' : '');
            //для фишечных кампаний не показываем сообщение про НДС
            this.setMod(this.elem('sum-camp-with-nds'), 'visible', currency !== 'YND_FIXED' ? 'yes' : '');
        },

        /**
         * Обработчик клика по кнопке «Оплатить», «Оплатить Яндекс.Деньгами»
         * валидирует цены при клике
         * @param {Event} e
         * @private
         */
        _onValidationForm: function(e) {
            var listItemsError = this.findBlocksOn('row', { block: 'b-campaigns-list-item', modName: 'error',
                modVal: 'yes' });

            listItemsError.length ?
                confirm.open({
                    type: 'alert',
                    limited: true,
                    message: iget2('b-campaigns-list', 'nepravilno-ukazana-summa-v', 'Неправильно указана сумма в кампании №') + ' ' +
                        listItemsError.map(function(listItem) {
                            return listItem.getCid();
                        }).join(', '),
                    onYes: function() {
                        listItemsError[0].focusInput();
                    }
                }) :
                this._submitPayForm(e);
        },

        /**
         * Отправляет данные об оплате на сервер
         * @param {Event} e
         * @private
         */
        _submitPayForm: function(e) {
            var payType,
                payParams;

            this.hasMod(e.block.domElem, 'money', 'yandex') && (payType = 'yamoney');

            try {
                yaCounter191494.reachGoal('PAY-PROF');
                yaCounter18641516.reachGoal('PAY-PROF');
            } catch (err) {}

            payParams = this._buildPayParams(payType);

            BEM.create({ block: 'i-request', mods: { type: 'form' } }, {
                url: payParams.action
            }).submit(payParams.params);
        },

        /**
         * Формирует параметры формы оплаты
         * @param {String} payType
         * @returns {Object}
         * @private
         */
        _buildPayParams: function(payType) {
            var payParams = this.elemParams('form-pay');

            if (payType == 'yamoney') {
                delete payParams.params.money_type;
                payParams.params.yamoney_camps = 1;
            }

            this._campsCidsToPay.forEach(function(cid) {
                payParams.params['sum_' + cid] = this._campModelsHash[cid].get('sumInput');
            }, this);

            return payParams;
        },

        /**
         * @type {Array}
         * @private
         */
        _button: null,

        /**
         * Возвращает кнопки «Оплатить», «Оплатить Яндекс.Деньгами»
         * @returns {Array}
         * @private
         */
        _getPayButtons: function() {
            return this._button || (this._button = this.findBlocksOn('button-pay', 'button'));
        },

        /**
         * Меняет состояние кнопок «Оплатить», «Оплатить Яндекс.Деньгами» ('disabled', 'yes', '')
         * @param {Boolean} needDisabled
         * @private
         */
        _toggleDisabledPayButtons: function(needDisabled) {
            this._getPayButtons().forEach(function(payButton) {
                payButton.setMod('disabled', needDisabled ? 'yes' : '');
            }, this);
        },

        /**
         * Показывает кнопку Оплатить Яндекс.Деньгами,
         * используя данные из export.yandex.ru/counters-js.xml?services=45
         * @private
         */
        _showYaMoneyButton: function() {
            var yaMoneyButton = this.elem('button-pay', 'money', 'yandex'),
                inboxCounters = window.inboxCounters;

            if (!yaMoneyButton.length) return;

            if (inboxCounters && inboxCounters.services && inboxCounters.services.money) {
                if (inboxCounters.services.money.notactive || inboxCounters.services.money.notpaypass) {
                    return;
                }

                this.delMod(yaMoneyButton, 'visibility');
            }
        },

        /* END Оплата кампаний */

        /* setIgnoredCamps */

        /**
         * Игнорирование компаний по инициализации
         * @returns {BEM}
         */
        _setIgnoredCamps: function(ignored) {
            this._getGroups().forEach(function(bCheckboxGroup, indexGroup) {

                bCheckboxGroup.setIgnored(ignored[indexGroup]);

            });
        },

        /* END setIgnoredCamps */

        /* Mass actions */

        /**
         * Обработчик события окончания поиска для массовых действий
         * @private
         * @param {jQuery.Event} [e]
         * @param {Object} [data]
         *  @param {Object} data.iterator итератор поиска
         */
        _onSearchFinishForActions: function(e, data) {
            var hidden = data.iterator.hidden;

            this._getGroups().forEach(function(bCheckboxGroup, indexGroup) {
                var from = this._getFromByIndexGroup(indexGroup),
                    to = this._getToByIndexGroup(indexGroup),
                    ignored = {};

                $.grep(hidden, function(indexHidden) {
                    return indexHidden >= from && indexHidden < to;
                }).forEach(function(indexHidden) {
                    ignored[indexHidden - from] = true;
                }, this);

                bCheckboxGroup.setIgnored(ignored);
            }, this);
        },

        /**
         * Возвращает cid из js-параметров конкретного 'b-campaigns-list-item'
         * @private
         * @param {Number} index
         */
        _getCampsItemCid: function(index) {
            return this._campsListItems[index].getCid();
        },

        /**
         * @private
         * @type {Array}
         */
        _checkedByGroup: [],

        /**
         * Обработчик изменений в группе чекбоксов
         * @private
         * @param {jQuery.Event} [e]
         * @param {Object} [data] Объект с индексами выбранных чекбоксов
         */
        _onCheckboxesChange: function(e, data) {
            var groupIndex = this.elem('group').index(e.block.domElem),
                from = this._getFromByIndexGroup(groupIndex),
                checked = [];

            this._checkedByGroup[groupIndex] = data.indexes
                .map(function(indexCheckboxByGroup) {
                    return this._getCampsItemCid(+indexCheckboxByGroup + from);
                }, this);

            this._checkedByGroup.forEach(function(checkedGroup) {
                checked = checked.concat(checkedGroup);
            });

            this._getMassActions().updateActions(checked);
        },

        /**
         * Возвращает индекс с которого начинаются кампании в группе
         * @private
         * @param {Number} index индекс группы
         * @returns {Number|null}
         */
        _getFromByIndexGroup: function(index) {
            var params = this._getGroupParams(index);

            return params ? params.from : null;
        },

        /**
         * Возвращает максимальный индекс кампании в группе
         * @private
         * @param {Number} index
         * @returns {Number|null}
         */
        _getToByIndexGroup: function(index) {
            var params = this._getGroupParams(index);

            return params ? params.to : null;
        },

        _groupParams: null,

        _getGroupParams: function(index) {
            this._groupParams || (this._groupParams = []);

            if (this._groupParams[index] === undefined) {
                var group = this.elem('group').eq(index);

                this._groupParams[index] = group.length ? this.elemParams(group) : null;
            }

            return this._groupParams[index];
        },

        /**
         * @private
         * @type {BEM[]}
         */
        _groups: null,

        /**
         * Возвращает экземпляры блоков 'b-checkboxes-group'
         * @private
         * @returns {BEM[]}
         */
        _getGroups: function() {
            return this._groups || (this._groups = this.findBlocksOn('group', 'b-checkboxes-group'))
        }

        /* END Mass actions */

    });

})();
