block('b-campaigns-select').def()(function() {
    var maxCampaignsCountWithoutFilter = 9,
        useFiltration = (this.ctx.campaigns || []).length > maxCampaignsCountWithoutFilter;

    return applyCtx({
        block: 'select',
        mix: [{
            block: 'b-campaigns-select'
        }].concat(this.ctx.mix || []),
        mods: u._.extend(
            { size: 's', theme: 'normal' },
            this.mods,
            useFiltration ? { type: 'with-filters' } : {}
        ),
        name: this.ctx.name,
        content: [
            {
                block: 'button',
                content: this.ctx.defaultText || ''
            },
            useFiltration ?
                {
                    elem: 'simple-filter',
                    filterByKey: true,
                    hint: this.ctx.inputHint,
                    empty: this.ctx.emptyHint,
                    hashMap: this.ctx.campaigns.reduce(function(hash, campaign) {
                        hash[campaign.cid] = campaign.name;

                        return hash;
                    }, {})
                } :
                '',
            {
                elem: 'control',
                content: u['b-campaigns-select']
                    .generateItemList(this.ctx.campaigns, {
                        disabledIds: this.ctx.disabledCampaigns,
                        addEmpty: this.ctx.addEmpty,
                        selectNone: this.ctx.selectNone
                    })
                    .map(function(item) {
                        var attrs = { value: item.value };

                        item.selected && (attrs.selected = 'selected');
                        item.disabled && (attrs.disabled = 'disabled');

                        return {
                            elem: 'option',
                            attrs: attrs,
                            content: item.text
                        };
                    })
            }
        ]
    })
});
