BEM.DOM.decl('b-campaigns-select', {
    onSetMod: {
        js: function() {
            this._select = this.findBlockOn('select');

            this._subscribe = BEM.create('i-subscription-manager');

            this._subscribe.wrap(this._select).on('change', this.trigger, this);
        }
    },

    destruct: function() {
        this._subscribe.dispose();
        this.__base.apply(this, arguments);
    },

    /**
     * Устанавливает новый список кампаний
     * @param {Object[]} campaigns - список кампаний
     *     @param {String} campaigns.cid - id кампании
     *     @param {String} campaigns.name - название кампании
     *     @param {String} campaigns.selected - признак: кампания выбрана
     * @param {Object} opts - дополнительные настройки списка кампаний
     *     @param {String[]} opts.disabledIds - список id заблокированных для выбора кампаний
     *     @param {Boolean} opts.addEmpty - признак: добавить в список пустое значение
     *     @param {Boolean} opts.selectNone - признак: по умолчанию кампания не выбрана
     */
    setCampaigns: function(campaigns, opts) {
        var value = this._select.val(), items;

        // todo@dima117a: костыль для добавления пустого элемента
        !!value && (opts.addEmpty = false);

        items = u['b-campaigns-select']
            .generateItemList(campaigns, opts)
            .map(function(item) {
                return {
                    item: 'option',
                    value: item.value,
                    content: item.text,
                    disabled: item.disabled,

                    // todo@dima117a: разный формат описания элементов для шаблонов и клиентского кода (отличается определение значения поля selected)
                    selected: item.value === value
                };
            });

        this._select.setOptions(items);
    }
});
