(function(u) {

    var thisUtils = {

        /**
         * Текст, который отображается, если ничего не  выбрано
         */
        EMPTY_TEXT: iget2('b-campaigns-select', 'vyberite-kampaniyu', 'Выберите кампанию'),

        /**
         * Максимальная длина названия кампании в списке
         */
        SHORT_CAMPAIGN_NAME_LENGTH: 28,

        /**
         * Формирует текст для элемента списка
         *
         * @param {String} cid - id кампании
         * @param {String} name - название кампании
         * @returns {string}
         */
        formatItemText: function(cid, name) {
            return '&#8470;' + cid + ' ' + u.hellipSplit(name, thisUtils.SHORT_CAMPAIGN_NAME_LENGTH)
        },

        /**
         * Элемент списка кампаний
         * @typedef {Object} CampaignListItem
         * @property {String} text - название кампании
         * @property {String} value - ID кампании
         * @property {Boolean} selected - признак: кампания выбрана
         * @property {Boolean} disabled - признак: кампания заблокирована для выбора
         *
         *
         * Формирует список элементов селектора кампаний
         * @param {Object[]} campaigns - список кампаний
         *     @param {String} campaigns.cid - id кампании
         *     @param {String} campaigns.name - название кампании
         *     @param {String} campaigns.selected - признак: кампания выбрана
         * @param {Object} options - дополнительные настройки списка кампаний
         *     @param {String[]} options.disabledIds - список id заблокированных для выбора кампаний
         *     @param {Boolean} options.addEmpty - признак: добавить в список пустое значение
         *     @param {Boolean} options.selectNone - признак: по умолчанию кампания не выбрана
         * @returns {CampaignListItem[]}
         */
        generateItemList: function(campaigns, options) {
            !campaigns && (campaigns = []);
            !options && (options = {});

            var disabledIds = options.disabledIds || [],
                selectNone = options.selectNone,
                items = [];

            options.addEmpty && items.push({
                text: thisUtils.EMPTY_TEXT,
                value: '',
                selected: !!selectNone,
                disabled: false
            });

            campaigns.forEach(function(campaign) {
                items.push({
                    text: thisUtils.formatItemText(campaign.cid, campaign.name),
                    value: campaign.cid,
                    selected: !selectNone && campaign.selected,
                    disabled: ~disabledIds.indexOf(campaign.cid)
                });
            });

            return items;
        }
    };

    u.register({ 'b-campaigns-select': thisUtils });
})(u);
