block('b-campaigns-settings').elem('content').def()(function() {
    var data = this.data,
        form = data.FORM,
        hiddenInputs = [],
        paramsFromForm = this.extend(form, {
            sort: 'settings'
        }),
        key,
        settingsValue = form.settings_sorted,
        pos = this.sortSettings.hash[settingsValue] && this.sortSettings.hash[settingsValue].pos || 0,
        excludeParams = /^ncrnd|uid_url|authredirlevel|INCLUDE_PATH|settings_sorted|reverse|page$/;

    for (key in paramsFromForm) paramsFromForm.hasOwnProperty(key) && !excludeParams.exec(key) &&
        hiddenInputs.push({
            name: key,
            value: paramsFromForm[key]
        });

    return {
        block: 'b-form',
        mods: {
            'auto-submit': 'yes'
        },
        mix: [{
            block: 'b-campaigns-settings',
            elem: 'content'
        }],
        action: data.SCRIPT,
        method: 'GET',
        header: iget2('b-campaigns-settings', 'pokazat-pervymi-kampanii-s', 'Показать первыми кампании с настройкой:'),
        hiddenInputs: hiddenInputs,
        rows: this.sortSettings.arr.map(function(item, index) {
            return {
                input: {
                    block: 'radiobox',
                    mix: {
                        block: 'b-campaigns-settings',
                        elem: 'settings-radiobox',
                        elemMods: { large: item.large ? 'yes' : '' }
                    },
                    js: {
                        id: 'settings_sorted'
                    },
                    name: 'settings_sorted',
                    content: [
                        {
                            elem: 'radio',
                            elemMods: index == pos ? { checked: 'yes' } : '',
                            content: item.name,
                            controlAttrs: {
                                value: item.value
                            }
                        }
                    ]
                }
            };
        }),
        submit: [
            {
                block: 'button',
                type: 'submit',
                content: iget2('b-campaigns-settings', 'pokazat', 'Показать')
            },
            {
                block: 'button',
                mix: [{
                    block: 'b-campaigns-settings',
                    elem: 'cancel'
                }],
                content: iget2('b-campaigns-settings', 'otmenit', 'Отменить')
            }
        ]
    };
});
