block('b-captcha-form')(

    tag()('form'),

    attrs()(function() {
        return {
            action: this.ctx.action,
            method: this.ctx.method
        };
    }),

    content()(function() {
        var form = this.ctx.formData || {},
            requestParams = [];

        Object.keys(form).forEach(function(key) {
            var value = form[key];

            if (/INCLUDE_PATH|uid_url|captcha_id|captcha_code/.test(key) || !value) {
                return;
            } else if (/^json_/.test(key)) {
                // ignore stringify
                value = JSON.stringify(value);
            }

            requestParams.push({
                elem: 'hidden-input',
                name: key,
                value: value
            });
        });

        return [
            {
                elem: 'hidden-input',
                name: 'captcha_id',
                value: this.ctx.captchaId
            },
            requestParams,
            {
                block: 'input',
                js: { autoFocus: 'yes' },
                name: 'captcha_code',
                content: {
                    elem: 'control',
                    attrs: { autocomplete: 'off' }
                }
            },
            {
                elem: 'hint',
                content: [
                    iget2(
                        'b-captcha-form',
                        'dlya-podtverzhdeniya-togo-chto',
                        'Для подтверждения того, что Вы человек, а не программа, введите, пожалуйста, контрольные символы.'
                    ),
                    ' ',
                    iget2(
                        'b-captcha-form',
                        'zapros-simvolov-periodicheski-predprinimaetsya',
                        'Запрос символов периодически предпринимается для более надежного обеспечения конфиденциальности вашей информации.'
                    )
                ]
            },
            this.ctx.isInvalid && {
                elem: 'invalid',
                content: iget2('b-captcha-form', 'vy-nepravilno-vveli-kontrolnye', 'Вы неправильно ввели контрольные символы')
            },
            {
                block: 'button',
                type: 'submit',
                content: iget2('b-captcha-form', 'ok', 'OK')
            },
            {
                elem: 'captcha',
                tag: 'img',
                attrs: { src: this.ctx.captchaUrl }
            }
        ];
    }),

    elem('hidden-input')(
        tag()('input'),

        attrs()(function() {
            return {
                name: this.ctx.name,
                value: this.ctx.value,
                type: 'hidden'
            };
        })
    )
);
