block('b-captcha')(
    js()(true),

    content()(function() {
        return [
            {
                elem: 'image-box',
                content: [
                    {
                        elem: 'image',
                        tag: 'img',
                        attrs: {
                            src: this.ctx.url
                        }
                    },
                    {
                        elem: 'refresh',
                        content: [
                            {
                                block: 'link',
                                mods: {
                                    pseudo: 'yes',
                                    inner: 'yes'
                                },
                                mix: {
                                    block: 'b-captcha',
                                    elem: 'refresh-toggler'
                                },
                                js: {
                                    action: 'refresh'
                                },
                                content: [
                                    {
                                        block: 'b-icon',
                                        mods: {
                                            type: 'refresh'
                                        },
                                        mix: {
                                            block: 'b-captcha',
                                            elem: 'refresh-icon'
                                        }
                                    },
                                    {
                                        elem: 'inner',
                                        content: iget2('b-captcha', 'pokazat-druguyu-kartinku', 'показать другую картинку')
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'arrow'
            },
            {
                elem: 'answer-box',
                content: [
                    {
                        elem: 'answer-title',
                        content: iget2('b-captcha', 'vvedite-simvoly-s-kartinki', 'Введите символы с картинки слева') + ':'
                    },
                    {
                        elem: 'answer-input',
                        content: {
                            block: 'input',
                            js: {
                                action: 'captcha-code'
                            },
                            mix: {
                                block: 'b-captcha',
                                elem: 'code-input'
                            },
                            content: {
                                elem: 'control',
                                attrs: {
                                    tabindex: this.ctx.tabindex || 1,
                                    maxlength: 20,
                                    autocomplete: 'off'
                                }
                            }
                        }
                    },
                    {
                        elem: 'answer-hint',
                        content: iget2('b-captcha', 'robot-ne-smozhet-vvesti', 'Робот не сможет ввести символы с картинки, а вы сможете.')
                    },
                    !!this.ctx.error && this.ctx.error
                ]
            }
        ];
    })
);
