BEM.DOM.decl('b-captcha', {
    onSetMod: {
        js: function() {
            this._captchaId = this.params.captchaId;
            this._code = null;

            u.graspSelf.call(this, {
                _refresh: 'link on refresh-toggler',
                _codeInput: 'input on code-input'
            });

            this._refresh.on('click', function() {
                this.refresh();
            }, this);

            this._codeInput.on('change', function(e) {
                this.trigger('change', { val: this._code = e.target.val(), id: this._captchaId });
            }, this);
        }
    },

    /**
     * Возвращает введенный код каптчи.
     *
     * @returns {null|String}
     */
    getVal: function() {
        return this._code;
    },

    /**
     * Возвращает id каптчи.
     *
     * @returns {String}
     */
    getId: function() {
        return this._captchaId;
    },

    /**
     * Обновляет каптчу
     */
    refresh: function() {
        this._codeInput.val('');
        this.setMod('refreshing', 'yes');

        BEM.create('i-request_type_ajax', {
            cache: false,
            url: '/registered/main.pl',
            dataType: 'json',
            callbackCtx: this,
            onError: (function(response) {
                // новая каптча всегда приходит со статусом 429
                if (response.status === 429) {
                    try {
                        var data = JSON.parse(response.responseText);

                        this._onResponse(data);
                    } catch (e) {}
                }

                // даем анимации сделать полный луп и затем останавливаем
                this.bindTo('refresh-icon', 'webkitAnimationIteration animationiteration', function() {
                    this.delMod('refreshing');
                    this.unbindFrom('refresh-icon', 'webkitAnimationIteration animationiteration');
                });
            }).bind(this)
        }).get({ cmd: 'showCaptcha', ajax: true }, this._onResponse);
    },

    _onResponse: function(result) {
        this.findElem('image').attr('src', result.captcha_url);
        this.trigger('change', { val: this._code, id: this._captchaId = result.captcha_id });
    }
});
