block('b-cert-list-item').mod('type', 'admin')(

    elem('left').content()(function() {
        return [
            {
                block: 'link',
                mix: {
                    block: 'b-cert-list-item',
                    elem: 'title'
                },
                url: u.getUrl('apiCertificationShowRequest', {
                    app_request_id: this.ctx.app_request_id,
                    application_id: this.ctx.appId,
                    ulogin: this.ctx.ulogin,
                    access_type: this.ctx.access_type
                }),
                content: this.ctx.name
            },
            {
                elem: 'app-id',
                content: this.ctx.appId,
                tag: 'span'
            },
            !!this.ctx.description && {
                elem: 'descr',
                content: this.ctx.description
            },
            !!this.ctx.otherInfo && {
                elem: 'descr',
                content: this.ctx.otherInfo
            },
            !!this.ctx.comment && {
                elem: 'comment',
                author: {
                    login: this.ctx.manager_login,
                    domainLogin: this.ctx.manager_domain_login
                },
                content: this.ctx.comment
            },
            this.ctx.app_access && {
                elem: 'comment',
                elemMods: { type: 'app-access' },
                author: {
                    login: this.ctx.app_access.manager_login,
                    domainLogin: this.ctx.app_access.manager_domain_login
                },
                content: this.ctx.app_access.comment
            }
        ];
    }),

    elem('comment')(

        content()(function() {
            return [
                applyNext(),
                this.ctx.author.login && {
                    elem: 'comment-editor',
                    author: this.ctx.author
                }
            ];
        }),

        elemMod('type', 'app-access').content()(function() {
            return [
                {
                    elem: 'comment-title',
                    content: iget2('b-cert-list-item', 'dostup-prilozheniya', 'Доступ приложения')
                },
                u.escapeHTML(this.ctx.content),
                this.ctx.author.login && {
                    elem: 'comment-editor',
                    author: this.ctx.author
                }
            ];
        })
    ),

    elem('comment-editor').content()(function() {
        return [
            {
                elem: 'comment-editor-label',
                content: [iget2('b-cert-list-item', 'obrabotal', 'Обработал'), ': ']
            },
            {
                elem: 'comment-editor-author',
                content: {
                    block: 'link',
                    url: u.formatUrl({
                        host: 'http://staff.yandex-team.ru',
                        path: u.escapeHTML(this.ctx.author.domainLogin)
                    }),
                    content: this.ctx.author.login
                }
            }
        ];
    }),

    elem('right').content()(function() {
        return (applyNext() || []).concat([
            this.ctx.app_access && {
                elem: 'right-row',
                title: iget2('b-cert-list-item', 'dostup-prilozheniya-100', 'доступ приложения'),
                type: this.ctx.app_access.found ? 'approve' : 'reject',
                content: [
                    this.ctx.app_access.found ? iget2('b-cert-list-item', 'vklyuchen', 'включен') : iget2('b-cert-list-item', 'vyklyuchen', 'выключен'),
                    !!this.ctx.app_access.check_time && {
                        elem: 'check-time',
                        content: '(' + this.ctx.app_access.check_time + ')'
                    }
                ]
            }
        ]);
    }),

    elem('toolbar').content()(function() {
        var item = this.ctx.item,
            statusTexts = {
                Approve: iget2('b-cert-list-item', 'odobrena', 'одобрена'),
                Reject: iget2('b-cert-list-item', 'otklonena', 'отклонена'),
                New: iget2('b-cert-list-item', 'novaya', 'новая')
            },
            accessTypeTexts = {
                test: iget2('b-cert-list-item', 'testovyy', 'тестовый'),
                normal: iget2('b-cert-list-item', 'polnyy', 'полный')
            };

        return [
            item.status !== 'Approve' && {
                block: 'b-outboard-controls',
                js: { id: 'cer-list' },
                mix: [{ block: 'b-cert-list-item', elem: 'toolbar-item' }],
                content: {
                    elem: 'switcher',
                    js: {
                        innerBlockParams: {
                            application_id: item.application_id,
                            access_type: item.access_type,
                            ulogin: item.ulogin,
                            action: 'approve'
                        }
                    },
                    switcher: {
                        block: 'link',
                        mods: { pseudo: 'yes' },
                        content: iget2('b-cert-list-item', 'prinyat', 'Принять')
                    }
                }
            },
            item.status !== 'Reject' && {
                block: 'b-outboard-controls',
                js: { id: 'cer-list' },
                mix: [{ block: 'b-cert-list-item', elem: 'toolbar-item' }],
                content: {
                    elem: 'switcher',
                    js: {
                        innerBlockParams: {
                            application_id: item.application_id,
                            access_type: item.access_type,
                            ulogin: item.ulogin,
                            action: 'reject'
                        }
                    },
                    switcher: {
                        block: 'link',
                        mods: { pseudo: 'yes' },
                        content: iget2('b-cert-list-item', 'otklonit', 'Отклонить')
                    }
                }
            },
            item.history && item.history.length && {
                elem: 'toolbar-item',
                text: {
                    block: 'dropdown',
                    content: [
                        {
                            block: 'link',
                            mods: { pseudo: 'yes' },
                            mix: [{ block: 'dropdown', elem: 'switcher' }],
                            content: [iget2('b-cert-list-item', 'istoriya-izmeneniy', 'История изменений'), ' (', item.history.length, ')']
                        },
                        {
                            elem: 'popup',
                            mix: [{ block: 'b-cert-list-item', elem: 'history' }],
                            content: item.history.map(function(record) {
                                var date = record.create_time,
                                    accessType = accessTypeTexts[record.access_type],
                                    status = statusTexts[record.status];

                                return {
                                    block: 'b-cert-list-item',
                                    elem: 'history-record',
                                    content: {
                                        block: 'link',
                                        url: u.getUrl('apiCertificationGetHistory', {
                                            application_id: item.application_id,
                                            create_time: record.create_time,
                                            ulogin: item.ulogin
                                        }),
                                        content: [date, ' - ', accessType, ' - ', status]
                                    }
                                };
                            })
                        }
                    ]
                }
            },
            {
                elem: 'app-access',
                content: [
                    item.access_type == 'test' && {
                        block: 'link',
                        mods: { pseudo: 'yes' },
                        mix: [
                            {
                                block: 'b-cert-list-item',
                                elem: 'sandbox-resend'
                            },
                            {
                                block: 'b-cert-list-item',
                                elem: 'toolbar-item'
                            }
                        ],
                        content: iget2('b-cert-list-item', 'sandbox', 'Sandbox')
                    },
                    {
                        block: 'b-outboard-controls',
                        js: { id: 'cer-list-app-access' },
                        mix: [{ block: 'b-cert-list-item', elem: 'toolbar-item' }],
                        content: {
                            elem: 'switcher',
                            js: {
                                innerBlockParams: {
                                    application_id: item.application_id,
                                    ulogin: item.ulogin,
                                    access_type: item.access_type,
                                    action: item.app_access && item.app_access.found == 1 ? 'disable' : 'enable'
                                }
                            },
                            switcher: {
                                block: 'link',
                                mods: { pseudo: 'yes' },
                                content: item.app_access && item.app_access.found == 1 ? iget2('b-cert-list-item', 'vyklyuchit-prilozhenie', 'Выключить приложение') : iget2('b-cert-list-item', 'vklyuchit-prilozhenie', 'Включить приложение')
                            }
                        }
                    }
                ]
            },
            item.app_access && item.app_access.found == 1 && {
                elem: 'app-enable-old-api-versions',
                content: [
                    {
                        elem: 'app-enable-old-api-versions-label',
                        content: iget2('b-cert-list-item', 'dostup-k-zakrytym-starym', 'Доступ к закрытым старым версиям API:')
                    },

                    {
                        block: 'radio-button',
                        name: 'min-api-version-override',
                        value: item.app_access.min_api_version_override,
                        mix: [{ block: 'b-cert-list-item', elem: 'min-api-version-override' }],
                        content: [
                            {
                                elem: 'radio',
                                controlAttrs: { value: '0' },
                                content: iget2('b-cert-list-item', 'zakryt', 'закрыт')
                            },
                            {
                                elem: 'radio',
                                controlAttrs: { value: '104' },
                                content: iget2('b-cert-list-item', 'tolko-4-live', 'только 4-live')
                            },
                            {
                                elem: 'radio',
                                controlAttrs: { value: '4' },
                                content: iget2('b-cert-list-item', '4-i-4-live', '4 и 4-live')
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
