block('b-cert-list-item')(

    js()(function() {
        return {
            appId: this.ctx.data.application_id,
            ulogin: this.ctx.data.ulogin,
            app_request_id: this.ctx.data.app_request_id
        };
    }),

    content()(function() {
        var item = this.ctx.data;

        return [
            {
                elem: 'right',
                createTime: item.create_time,
                checkTime: item.check_time,
                endTime: item.end_time,
                status: (item.status || '').toLowerCase(),
                access: (item.access_type || '').toLowerCase(),
                app_access: item.app_access,
                hideEndTime: this.ctx.hideEndTime
            },
            {
                elem: 'left',
                name: u.escapeHTML(item.name || ''),
                ulogin: item.ulogin,
                appId: item.application_id,
                app_request_id: item.cr_id,
                access_type: (item.access_type || '').toLowerCase(),
                comment: u.escapeHTML(item.comment || ''),
                description: u.escapeHTML(item.description || ''),
                otherInfo: u.escapeHTML(item.other_info || ''),
                app_access: item.app_access,
                manager_login: item.manager_login,
                manager_domain_login: item.manager_domain_login
            },
            {
                elem: 'toolbar',
                isUser: true,
                access_type: (item.access_type || '').toLowerCase(),
                appId: item.application_id,
                app_request_id: item.cr_id,
                ulogin: u.escapeHTML(item.ulogin || ''),
                item: item
            }
        ];
    }),

    elem('right').content()(function() {
        var texts = {
            approve: iget2('b-cert-list-item', 'odobrena', 'одобрена'),
            reject: iget2('b-cert-list-item', 'otklonena', 'отклонена'),
            new: iget2('b-cert-list-item', 'novaya', 'новая'),
            test: iget2('b-cert-list-item', 'testovyy', 'тестовый'),
            normal: iget2('b-cert-list-item', 'polnyy', 'полный')
        };

        return [
            {
                elem: 'right-row',
                title: iget2('b-cert-list-item', 'data-zayavki', 'дата заявки'),
                content: this.ctx.createTime
            },
            !!this.ctx.checkTime && !this.ctx.hideEndTime && {
                elem: 'right-row',
                title: iget2('b-cert-list-item', 'deystvitelna-do', 'действительна до'),
                content: this.ctx.endTime
            },
            {
                elem: 'right-row',
                title: iget2('b-cert-list-item', 'dostup', 'доступ'),
                content: texts[this.ctx.access],
                type: this.ctx.access
            },
            {
                elem: 'right-row',
                title: iget2('b-cert-list-item', 'status', 'статус'),
                type: this.ctx.status,
                content: [
                    texts[this.ctx.status],
                    !!this.ctx.checkTime && {
                        elem: 'check-time',
                        content: '(' + this.ctx.checkTime + ')'
                    }
                ]
            }
        ];
    }),

    elem('left').content()(function() {
        return [
            {
                block: 'link',
                mix: {
                    block: 'b-cert-list-item',
                    elem: 'title'
                },
                url: u.getUrl('apiCertificationEditRequest', {
                    application_id: this.ctx.appId,
                    access_type: this.ctx.access_type
                }),
                content: this.ctx.name
            },
            {
                elem: 'app-id',
                content: this.ctx.appId,
                tag: 'span'
            },
            !!this.ctx.description && {
                elem: 'descr',
                content: this.ctx.description
            },
            !!this.ctx.otherInfo && {
                elem: 'descr',
                content: this.ctx.otherInfo
            },
            !!this.ctx.comment && {
                elem: 'comment',
                content: this.ctx.comment
            }
        ]
    }),

    elem('right-row').content()(function() {
        return [
            {
                elem: 'right-row-text',
                content: this.ctx.content,
                elemMods: {
                    type: this.ctx.type
                }
            },
            {
                elem: 'right-row-title',
                content: this.ctx.title
            }
        ];
    }),

    elem('toolbar').content()(function() {
        var content = [],
            urlParams = {
                application_id: this.ctx.appId,
                access_type: this.ctx.access_type
            };

        if (this.ctx.isUser) {
            if (this.ctx.access_type === 'test') {
                content.push({
                    elem: 'toolbar-item',
                    url: u.getUrl('apiCertificationUpgradeRequest', u._.extend({}, urlParams, {
                        access_type: 'normal'
                    })),
                    text: iget2('b-cert-list-item', 'polnyy-dostup', 'Полный доступ')
                });
            }

            content.push([
                {
                    elem: 'toolbar-item',
                    url: u.getUrl('apiCertificationEditRequest', urlParams),
                    text: iget2('b-cert-list-item', 'redaktirovat', 'Редактировать')
                },
                {
                    elem: 'toolbar-item',
                    mix: {
                        block: 'b-cert-list-item',
                        elem: 'delete-action'
                    },
                    appId: this.ctx.appId,
                    url: u.getUrl(
                        'ajaxCertificationDeleteRequest',
                        this.ctx.ulogin ? u._.extend({}, urlParams, {
                            ulogin: this.ctx.ulogin
                        }) : urlParams),
                    text: iget2('b-cert-list-item', 'udalit', 'Удалить')
                }
            ]);
        }

        return content;
    }),

    elem('toolbar-item').content()(function() {
        return {
            block: 'link',
            mix: this.ctx.mix,
            url: this.ctx.url,
            content: this.ctx.text
        };
    }),

    elem('comment').content()(function() {
        return [{
            elem: 'comment-title',
            content: iget2('b-cert-list-item', 'kommentarii', 'Комментарии')
        }, this.ctx.content];
    })
);
