BEM.DOM.decl('b-chart-button', {
    onSetMod: {
        js: function() {
            this._chartsButton = this.findBlockInside('button');
            this._spin = this.findBlockInside('spin');
            this._subscriptions = BEM.create('i-subscription-manager')
                .on(this._chartsButton, 'click', this._onLinkClick, this);
        },

        /**
         * при modVal == yes кнопка дизейблится и крутится спиннер
         * @param {String} modName - имя модификатора (loading)
         * @param {String} modVal - значение модификатора
         */
        loading: function(modName, modVal) {
            this._spin.setMod('progress', modVal == 'yes' ? 'yes' : '');
            this._chartsButton.setMod('disabled', modVal == 'yes' ? 'yes' : '');
        }
    },

    /**
     * Установка метода получения данных
     * @param {Function} getDeferredCallback - коллбек для получения данных, возвращает $.deferred
     */
    setDataSource: function(getDeferredCallback) {
        this._sourceData = getDeferredCallback;
    },

    /**
     * Уничтожает блок
     * @returns {BEM.DOM}
     */
    destruct: function() {
        this._subscriptions.dispose();
        return this.__base.apply(this, arguments);
    },

    /**
     * Показыват попап с графиком по нажатию на линк
     * Данные получает блок-родитель и предобрабатывает их
     * @private
     */
    _onLinkClick: function() {
        this.setMod('loading', 'yes');
        this._sourceData()
            .then(function(data, points, group) {
                var popup,
                    innerContent = BEMHTML.apply({
                        block: 'b-chart-pane',
                        statData: data,
                        points: points,
                        group: group
                    });
                this.setMod('loading', 'no');
                popup = BEM.blocks['b-shared-popup'].getInstance({ animate: 'yes', 'has-close': 'yes' },
                        { directions: ['left-middle-middle', 'top-right-left', 'bottom-right-left'] });
                popup.setContent(innerContent).toggle(this._chartsButton);
            }.bind(this),
            function(error) {
                BEM.blocks['b-confirm'].alert(iget2('b-chart-button', 'ne-udaetsya-zagruzit-grafik', 'Не удается загрузить график статистики'));
                this.setMod('loading', 'no');
            }.bind(this));
    }
});
