BEM.DOM.decl({
    block: 'b-chart-filter-control',
    modName: 'type',
    modVal: 'radio'
}, {
    onSetMod: {
        js: function() {
            this._radioButton = this.findBlockInside('radio-button');
            this._initEvents();
        }
    },

    _initEvents: function() {
        this.__base();

        this._radioButton &&
            this._subscribe.on(this._radioButton, 'change', this._onChange, this);
    },

    /**
     * Вызывается при изменении фильтра
     * @param {Event} e - событие
     * @param {FilterData.data} data - данные фильтра
     * @private
     */
    _onChange: function(e, data) {
        e.preventDefault();
        e.stopPropagation();
        this.trigger('change', { filter: this.params.name, data: data });
    },

    /**
     * Проверяет выключен ли элемент
     * @private
     */
    _isDisabled: function() {
        return this._radioButton.hasMod('disabled', 'yes');
    },

    /**
     * Устанавливает модификатор опциям
     * @param {Array<String>} options - массив идентификаторов опций (value)
     * @param {String} modName - имя модификатора
     * @param {String} modVal - значения модификатора
     * @private
     */
    _setOptionsMod: function(options, modName, modVal) {
        options.forEach(function(name) {
            var filterOption = this.elem('filter-option', 'name', name),
                radio = this.getFilterBlock().findElem(filterOption, 'radio');

            radio && this.getFilterBlock().setMod(radio, modName, modVal);
        }, this);
    },

    /**
     * Возвращает значение фильтра
     * @return {{filter, data}}
     */
    getValue: function() {
        return { filter: this.params.name, data: this._radioButton.val() };
    },

    /**
     * Выставляет значение фильтра
     * @param {String} value
     */
    setValue: function(value) {
        this._radioButton.val(value);
    },

    /**
     * Включает фильтр
     */
    enable: function() {
        this._radioButton.setMod('disabled', '');
    },

    /**
     * Выключает фильтр
     */
    disable: function() {
        this._radioButton.setMod('disabled', 'yes');
    },

    /**
     * Включает опции
     * @param {Array<String>} options - массив идентификаторов опций (value)
     */
    enableOptions: function(options) {
        this._setOptionsMod(options, 'disabled', '');
    },

    /**
     * Вылючает опции
     * @param {Array<String>} options - массив идентификаторов опций (value)
     */
    disableOptions: function(options) {
        this._setOptionsMod(options, 'disabled', 'yes');
    },

    /**
     * Возвращает блок фильтра
     * @return {*|BEM}
     */
    getFilterBlock: function() {
        return this._radioButton;
    },

    destruct: function() {
        this._subscribe.dispose();
        this.__base.apply(this, arguments);
    }

});
