BEM.DOM.decl({
    block: 'b-chart-filter-control',
    modName: 'type',
    modVal: 'select'
}, {
    onSetMod: {
        js: function() {
            this._selectFilter = this.findBlockInside('b-select-filter');
            this._initEvents();
        }
    },

    _initEvents: function() {
        this.__base();

        this._selectFilter &&
            this._subscribe.on(this._selectFilter, 'change', this._onChange, this);
    },

    /**
     * Вызывается при изменении фильтра
     * @param {Event} e - событие
     * @param {FilterData.data} data - данные фильтра
     * @private
     */
    _onChange: function(e, data) {
        e.preventDefault();
        e.stopPropagation();
        this.trigger('change', { filter: this.params.name, data: data });
    },

    /**
     * Проверяет выключен ли элемент
     * @private
     */
    _isDisabled: function() {
        return this._selectFilter.hasMod('disabled', 'yes');
    },

    /**
     * Возвращает значение фильтра
     * @return {{filter, data: ({text, name, value, selected, hidden, group?, extraParams, disabled}|Array)}}
     */
    getValue: function() {
        return { filter: this.params.name, data: this._selectFilter.getSelected() };
    },

    /**
     * Выставляет значение фильтра
     * @param {Array<String>} values - массив значений
     */
    setValue: function(values) {

        if (!Array.isArray(values)) { throw new Error('Argument must be array'); }

        this._selectFilter.setSelected(values);
    },

    /**
     * Включает фильтр
     */
    enable: function() {
        this._selectFilter.delMod('disabled');
    },

    /**
     * Выключает фильтр
     */
    disable: function() {
        this._selectFilter.setMod('disabled', 'yes');
    },

    /**
     * Включает опции
     * @param {Array<String>} options - массив идентификаторов опций (value)
     */
    enableOptions: function(options) {
        this._selectFilter.enableItems(options);
    },

    /**
     * Вылючает опции
     * @param {Array<String>} options - массив идентификаторов опций (value)
     */
    disableOptions: function(options) {
        this._selectFilter.disableItems(options);
    },

    /**
     * Возвращает блок фильтра
     * @return {*|BEM}
     */
    getFilterBlock: function() {
        return this._selectFilter;
    },

    destruct: function() {
        this._subscribe.dispose();
        this.__base.apply(this, arguments);
    }

});
