BEM.DOM.decl({ block: 'b-chart-filters', modName: 'limits', modVal: 'columns-groups' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._checkLimits();
        }
    },

    /**
     * Генерирует событие change блока, вызывается элементами
     *
     * @param {Event} e - событие
     * @param {FilterData} data - данные события
     * @private
     */
    _triggerFilterChange: function(e, data) {
        this._checkLimits();
        this.__base.apply(this, arguments);
    },

    /**
     * Проверяет ограничения для столбцов/срезов
     * @private
     */
    _checkLimits: function() {
        var currentValues = this.getValue({ disabled: true });
        this._checkGroupsLimits(currentValues);
        this._checkColumnsLimits(currentValues);
    },

    /**
     * Проверяет ограничения для срезов
     * @private
     */
    _checkGroupsLimits: function(values) {
        var columnsValue = u._.find(values, function(value) { return value.filter === 'columns'; }),
            groupFilterValues = this.getFilter('groupBy').getFilterBlock().getAll();

        columnsValue.data.length !== 1 ?
            this.disableFilter('groupBy') :
            groupFilterValues.length && this.enableFilter('groupBy');
    },

    /**
     * Проверяет ограничения для столбцов
     * @private
     */
    _checkColumnsLimits: function(values) {
        var groupsValue = u._.find(values, function(value) { return value.filter === 'groupBy'; }),
            columnsFilterBlock = this.getFilter('columns').getFilterBlock();

        groupsValue && u._.compact(groupsValue.data).length === 0 ?
            columnsFilterBlock.setMod('multi', 'yes') :
            columnsFilterBlock.delMod('multi');
    }

});
