BEM.DOM.decl({ block: 'b-chart-filters' }, {

    /**
     * @typedef {Object} FilterData
     * @property {String} filter - название фильтра
     * @property {Array|Object} data - значения фильтра
     */

    /**
     * Генерирует событие change блока, вызывается элементами
     *
     * @param {Event} e - событие
     * @param {FilterData} data - данные события
     * @private
     */
    _triggerFilterChange: function(e, data) {
        this.trigger('change', data);
    },

    /**
     * Включает фильтр (убирает модификатор disabled)
     * @param {String} name - имя фильтра
     */
    enableFilter: function(name) {
        this.getFilter(name)
            .enable();
    },

    /**
     * Выключает фильтр (добавляет модификатор disabled)
     * @param {String} name - имя фильтра
     */
    disableFilter: function(name) {
        this.getFilter(name)
            .disable();
    },

    /**
     * Возвращает инстанс элемента по имени
     * @param {String} name - имя фильтра
     * @return {*|BEM}
     */
    getFilter: function(name) {
        return this.findBlockInside(name, 'b-chart-filter-control')
    },

    /**
     * Возвращает состояния всех фильтров, по-умолчанию игнорирует выключенные
     * @param {Object} options
     * @param {Boolean} options.disabled - добавляет значения выключенных
     * @return {Array<FilterData>}
     */
    getValue: function(options) {
        var result = [];

        options = options || {};

        this.findBlocksInside('b-chart-filter-control')
            .forEach(function(filter) {
                (!filter._isDisabled() || options.disabled) &&
                    result.push(u._.extend(filter.getValue(),{ type: filter.getMod('type') }));
            });

        return result;
    },

    /**
     * Выставляет значение
     * @param {String} filter_name - название фильтра
     * @param {Array|String} value - значение
     */
    setValue: function(filter_name, value) {
        this.getFilter(filter_name).setValue(value);
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('change', 'b-chart-filter-control', function(e, data) {
            this._triggerFilterChange(e, data);
        });

    }

});
