block('b-chart').elem('tooltip')(
    content()(function() {
        if (!window.dna || !window.dna.utils) {
            return
        }

        var columns = this.ctx.title.columns,
            groupBy = this.ctx.title.groupBy,
            campaigns = this.ctx.filters.campaign,
            banners = this.ctx.filters.banner,
            adgroup_id = this.ctx.filters.adgroup_id,
            serialize = window.dna.utils.serializeLogFilterToString,
            filters = window.dna.utils.filtersForHistotyOfChanges,
            filterConditions = [],
            ulogin = u.consts('ulogin'); // клиент, статитстику которого смотрим

        if (filters) {
            if (campaigns && campaigns.eq.length) {
                filterConditions.push({
                    field: filters.CID,
                    operator: '=',
                    value: {
                        type: 'text',
                        value: campaigns.eq.join(',')
                    }
                })
            }
            if (adgroup_id) {
                filterConditions.push({
                    field: filters.GROUPS,
                    operator: '=',
                    value: {
                        type: 'text',
                        value: adgroup_id.eq
                    }
                })
            }

            if (banners) {
                filterConditions.push({
                    field: filters.BANNERS,
                    operator: '=',
                    value: {
                        type: 'text',
                        value: banners.eq.replace(/[^\d,]/g, '')
                    }
                })
            }
        }

        return [
            // показывает заголовок только для срезов
            !!groupBy.length && {
                block: 'b-chart',
                elem: 'tooltip-title',
                content: iget2('b-chart', 'column-stolbec-po-srezu', '{column} по срезу «{groupBy}»', {
                    column: columns[0],
                    groupBy: groupBy[0],
                    context: 'column - столбец; groupBy - срез'
                })
            },
            {
                block: 'b-chart',
                elem: 'tooltip-date',
                content: u.moment(this.ctx.points[0].x).format('DD MMMM YYYY'),
            },
            {
                block: 'b-chart',
                elem: 'tooltip-points',
                tag: 'table',
                content: [
                    this.ctx.points.map(function(point) {
                        return {
                            block: 'b-chart',
                            elem: 'tooltip-row',
                            tag: 'tr',
                            content: [
                                {
                                    block: 'b-chart',
                                    elem: 'tooltip-row-detail',
                                    elemMods: { type: 'point' },
                                    tag: 'td',
                                    content: {
                                        block: 'b-chart',
                                        elem: 'tooltip-point-color',
                                        tag: 'span',
                                        attrs: { style: 'background:' + point.color }
                                    }
                                },
                                {
                                    block: 'b-chart',
                                    elem: 'tooltip-row-detail',
                                    elemMods: { type: 'name' },
                                    tag: 'td',
                                    content: point.name
                                },
                                {
                                    block: 'b-chart',
                                    elem: 'tooltip-row-detail',
                                    elemMods: { type: 'value' },
                                    tag: 'td',
                                    content: point.y
                                }
                            ]
                        };
                    })
                ]
            },
            {
                block: 'link',
                text: iget2('b-chart', 'history-link', 'История изменений за этот день'),
                target: '_blank',
                url: u.formatUrl({
                    host: '/dna/log',
                    query: {
                        'date-from': u.moment(this.ctx.points[0].x).format('YYYY-MM-DD'),
                        'date-to': u.moment(this.ctx.points[0].x).format('YYYY-MM-DD'),
                        filter: serialize(filterConditions),
                        ulogin: ulogin
                    }
                }),
                mods: {
                    theme: 'pseudo'
                },
                mix: [
                    {
                        block: 'b-chart',
                        elem: 'history-link'
                    },
                    {
                        block: 'b-metrika2',
                        js: {
                            blockName: 'link',
                            target: 'CLICK_ON_LOG_LINK_FROM_MOL',
                            event: 'click'
                        }
                    }
                ]
            }
        ];
    })

);
