BEM.DOM.decl({ block: 'b-chart', modName: 'view', modVal: 'area' }, {

    _getChartViewParams: function() {
        return {
            chart: {
                type: 'area'
            },
            xAxis: {
                type: 'datetime'
            },
            colors: this._getColors(),
            tooltip: {
                crosshairs: true
            },
            plotOptions: {
                area: {
                    lineWidth: 0,
                    marker: {
                        enabled: false,
                        symbol: 'circle'
                    },
                    stacking: this.hasMod('stacking'),
                    states: {
                        hover: { // при наведении
                            halo: { // ободок вокруг точек
                                opacity: 0 // выключаем
                            }
                        }
                    }
                }
            }
        };
    },

    /**
     * https://wiki.yandex-team.ru/users/chizh/Palitra/
     * @returns {Array}
     * @private
     */
    _getColors: function() {
        return ['#77bb36', '#fdcc35', '#fc2500', '#469ee2', '#891e9c', '#d07e3c', '#e31754', '#0a379e', '#167e32'];
    }

}, {});
