BEM.DOM.decl({ block: 'b-chart', modName: 'view', modVal: 'line' }, {

    _getChartViewParams: function() {

        // самый простой способ повлиять на маркер в легенде для линейного графика
        u.Highcharts.seriesTypes.line.prototype.drawLegendSymbol =
            u.Highcharts.seriesTypes.area.prototype.drawLegendSymbol;

        return {
            chart: {
                type: 'line'
            },
            xAxis: {
                type: 'datetime'
            },
            colors: this._getColors(),
            tooltip: {
                crosshairs: true
            },
            plotOptions: {
                line: {
                    marker: {
                        enabled: false,
                        symbol: 'circle'
                    },
                    stacking: this.hasMod('stacking'),
                    states: {
                        hover: {
                            halo: {
                                opacity: 0
                            }
                        }
                    }
                }
            }
        };
    },

    /**
     * https://wiki.yandex-team.ru/users/chizh/Palitra/
     * @returns {Array}
     * @private
     */
    _getColors: function() {
        return ['#8bc554', '#fdcc35', '#fc4526', '#62ace6', '#9b40ab', '#d79159', '#e73a6d', '#2f55ac', '#399151'];
    }

}, {});
