block('b-charts-manager').elem('filters')(

    content()(function() {
        var checkedView = this.ctx.view || 'column',
            isPercOfImpDisabled = u.consts('isPercOfImpDisabled');

        if (checkedView === 'area') {
            checkedView = 'line';
        }

        return {
            block: 'b-chart-filters',
            mix: this.ctx.mix,
            mods: this.ctx.filtersMods,
            content: [
                {
                    block: 'b-chart-filter-control',
                    mods: { type: 'radio' },
                    mix: [
                        { block: 'b-chart-filters', elem: 'filter' },
                        { block: 'b-chart-filters', elem: 'view' }
                    ],

                    name: 'view',

                    control: {
                        values: [
                            {
                                name: 'column',
                                mods: {
                                    checked: checkedView === 'column' ? 'yes' : '',
                                    'only-icon': 'yes',
                                    'icon-size': '12'
                                },
                                content: [
                                    {
                                        block: 'radio-button',
                                        elem: 'icon',
                                        content: {
                                            block: 'icon',
                                            mods: { 'size-12': 'chart-columns' }
                                        }
                                    }

                                ]
                            },
                            {
                                name: 'line',
                                mods: {
                                    checked: checkedView === 'line' ? 'yes' : '',
                                    'only-icon': 'yes',
                                    'icon-size': '12'
                                },
                                content: [
                                    {
                                        block: 'radio-button',
                                        elem: 'icon',
                                        content: {
                                            block: 'icon',
                                            mods: { 'size-12': 'chart-line' }
                                        }
                                    }

                                ]
                            }
                        ]
                    }
                },
                this.ctx.columns && {
                    block: 'b-chart-filter-control',
                    mods: { type: 'select' },
                    mix: [
                        { block: 'b-chart-filters', elem: 'filter' },
                        { block: 'b-chart-filters', elem: 'columns' }
                    ],

                    name: 'columns',

                    control: {
                        text: iget2('b-charts-manager', 'stolbec', 'Столбец'),
                        values: isPercOfImpDisabled ? this.ctx.columns.filter(function(column) {
                            return column.value !== 'winrate'
                        }) : this.ctx.columns,
                        clear: {
                            text: iget2('b-charts-manager', 'ochistit-vse-stolbcy', 'Очистить все столбцы')
                        },
                        mods: {
                            multi: 'yes',
                            'group-limit': 2
                        },
                        hellipCut: 10,
                        messages: {
                            'filter-item': {
                                'group-limit': iget2(
                                    'b-charts-manager',
                                    'nelzya-odnovremenno-pokazat-dannye',
                                    'Нельзя одновременно показать данные 3-х типов столбцов. Отключите часть параметров'
                                ),
                                'winrate-disabled': iget2('b-charts-manager', 'vremenno-nedostupen-v-grafikah', 'Временно недоступен в графиках')
                            }
                        }
                    }

                },
                this.ctx.groups && {
                    block: 'b-chart-filter-control',
                    mods: { type: 'select' },
                    mix: [
                        { block: 'b-chart-filters', elem: 'filter' },
                        { block: 'b-chart-filters', elem: 'groupBy' }
                    ],

                    name: 'groupBy',

                    control: {
                        text: iget2('b-charts-manager', 'srez', 'Срез'),
                        values: this.ctx.groups,
                        clear: {
                            text: iget2('b-charts-manager', 'ochistit-srezy', 'Очистить срезы')
                        },
                        messages: {
                            switcher: {
                                disabled: this.ctx.groups.length && iget2('b-charts-manager', 'dlya-otobrazheniya-sreza-ostavte', 'Для отображения среза оставьте 1 столбец')
                            }
                        }
                    }

                }
            ]
        };
    })

);
