module.exports = {
    // Этот bemjson будет добавлен на страницу
    bemjson: {
        block: 'b-charts-manager',
        js: {
            clientCurrency: 'RUB',
            reportData: {
                filters: {},
                groupByDate: 'day',
                withNds: 1,
                date: { from: '2017-02-09', to: '2017-02-16' }
            }
        },
        content: [
            { elem: 'switcher' },
            {
                elem: 'filters',
                mods: { limits: 'columns-groups' },
                columns: [
                    { text: 'Показы', value: 'shows', selected: 'yes' },
                    { text: 'Клики', value: 'clicks' },
                    { text: 'CTR, %', value: 'ctr' },
                    { text: 'Цена, руб', value: 'price' }
                ],
                groups: [
                    { text: 'Пол', value: 'gender', group: 'gender', selected: 'yes' },
                    { text: 'Возраст', value: 'age', group: 'age' }
                ]
            },
            {
                elem: 'export',
                types: [
                    { text: 'PNG', MIME: 'image/png' },
                    { text: 'JPEG', MIME: 'image/jpeg' },
                    { text: 'SVG', MIME: 'image/svg+xml' }
                ],
                print: true
            },
            { elem: 'chart' }
        ]
    },

    // функция выполнится при загрузке на страницы
    init: function() {
        u['currencies'] = {
            getName: function() {
                return 'руб'
            }
        }
    }
};
