(function() {

    u.register({
        'b-charts-manager': {
            /**
             * Хэш, где ключ — единицаа измерения, значение ключа — список столбцов
             * правила бекенда protected/Stat/Plot.pm
             */
            groups: {
                percent: [
                    'ctr',                  // CTR (%)
                    'ectr',                 // eCTR (%)
                    'bounce_ratio',         // Post-click: Отказы (%)
                    'pv_bounce_ratio',      // Post-view: Отказы (%)
                    'aconv',                // Post-click: Конверсия (%)
                    'pv_aconv',             // Post-view: Конверсия (%)
                    'winrate',              // Процент полученных показов (%)
                    'auction_win_rate',     // Доля выигрышей (%)
                    'auction_hits',         // Участие в аукционах
                    'imp_reach_rate',       // SOV (%)
                    'video_first_quartile_rate',
                    'video_midpoint_rate',
                    'video_third_quartile_rate',
                    'video_complete_rate',
                    'avg_nshow_complete',
                    'video_true_view_rate',
                    'aprgoodmultigoal_conv_rate',
                    'pv_aprgoodmultigoal_conv_rate',
                    'agoalcrr'             // Доля рекламных расходов
                ],
                quantitative: [
                    'shows',                // Показы
                    'avg_nshow',
                    'clicks',               // Клики
                    'fp_clicks_avg_pos',    // Ср. позиция клика
                    'fp_shows_avg_pos',     // Ср. позиция показа
                    'eshows',               // Взвешенные показы
                    'avg_x',                // Ср. объём трафика
                    'adepth',               // Post-click: Глубина (стр.)
                    'pv_adepth',            // Post-view: Глубина (стр.)
                    'agoalnum',             // Post-click: Конверсии
                    'pv_agoalnum',          // Post-view: Конверсии
                    'avg_time_to_conv',     // Post-click: Ср. время до конверсии
                    'pv_avg_time_to_conv',  // Post-view: Ср. время до конверсии
                    'auction_wins',         // Выигрыши в аукционах
                    'served_impressions',   // Число выхода рекламы для outDoor && inDoor
                    'uniq_completed_viewers', // Достроенный охват для outDoor
                    'close_clicks',         // Клики закрытия
                    'close_ctr',            // CTR закрытия
                    'video_first_quartile',
                    'video_midpoint',
                    'video_third_quartile',
                    'video_complete',
                    'video_true_view',
                    'video_avg_true_view_cost',
                    'aprgoodmultigoal',
                    'pv_aprgoodmultigoal',
                    'agoalroi',             // Post-click: Рентабельность
                    'pv_agoalroi'           // Post-view: Рентабельность
                ],
                currency: [
                    'sum',                  // Расход всего
                    'av_sum',               // Ср. цена клика
                    'agoalcost',            // Post-click: Цена цели
                    'pv_agoalcost',         // Post-view: Цена цели
                    'agoalincome',          // Post-click: Доход
                    'pv_agoalincome',       // Post-view: Доход
                    'agoals_profit',        // Post-click: Прибыль
                    'pv_agoals_profit',     // Post-view: Прибыль
                    'aprgoodmultigoal_cpa',
                    'pv_aprgoodmultigoal_cpa'
                ]
            },

            /**
             * Добавляет каждому элементу списка поле group - едина измерения
             * @param {Array<Object>} list
             * @param {Object} [fields]
             * @param {String} [fields.takeFrom] - поле где хранится название столбца
             * @param {String} [fields.writeTo] - поле куда записать значение единицы измерения
             * @returns {Array<Object>}
             */
            applyGroup: function(list, fields) {
                fields = u._.extend({ takeFrom: 'value', writeTo: 'group' }, fields);

                return list.map(function(item) {
                    u._.keys(this.groups).some(function(groupName) {
                        if (this.groups[groupName].indexOf(item[fields.takeFrom]) !== -1) {
                            item[fields.writeTo] = groupName;

                            return true;
                        }

                        return false;
                    }, this);

                    return item;
                }, this);
            }

        }
    });

}());
