BEM.DOM.decl('b-checkbox-tree-item',
    {
        onSetMod: {
            js: function() {
                this.checkbox = this.findBlockInside('checkbox');
                this.subs = this.findBlocksInside(this.elem('subs'), 'b-checkbox-tree-item');

                this.checkbox.on('change', this._onChange, this);
                this.subs.forEach(function(sub) {
                    sub.checkbox.on('change', this._onInternalChange, this);
                }, this);
            }
        },

        /**
         * Замок, позволяющий не уходить в зацикливание при изменении состояния чекбокса
         */
        _inCheckedProccess: false,

        toggle: function(checked) {
            this.checkbox.toggleMod('checked', 'yes', checked);
        },

        /**
         * Обработчик изменения блока checkbox
         * @private
         */
        _onChange: function() {
            if (this._inCheckedProccess) return;

            var thisChecked = this.checkbox.isChecked();

            this.subs.forEach(function(subitem) {
                subitem.checkbox.toggleMod('checked', 'yes', thisChecked);
            });
        },

        /**
         * Обработчик изменения состояния чекбокс
         * @private
         */
        _onInternalChange: function(event) {
            var allChecked = !this.subs.some(function(sub) {
                return !sub.checkbox.isChecked();
            });

            this._inCheckedProccess = true;
            this.checkbox.toggleMod('checked', 'yes', allChecked);

            // событие срабатывает асинхронно
            this.afterCurrentEvent(function() {
                this._inCheckedProccess = false;
            });
        }
    }
);
