block('b-checklist')(

    def()(function() {
        this.mods.mode = this.mods.mode || 'multi';
        this.mods['one-item'] = this.ctx.items.length === 1 ? 'yes' : '';

        return applyNext();
    }),

    js()(function() {
        return { items: this.ctx.items };
    }),

    content()(function() {
        return [
            {
                block: 'radiobox',
                value: this.ctx.items[0].id,
                mix: [{
                    block: 'b-checklist',
                    elem: 'radiobox'
                }],
                content: {
                    block: 'b-checklist',
                    elem: 'list',
                    tag: 'ul',
                    content: this.ctx.items.map(function(ctx) {
                        ctx.elem = 'item';
                        ctx.elemMods = {
                            id: ctx.id,
                            type: ctx.type,
                            inactive: ctx.isActive ? '' : 'yes'
                        };

                        return ctx;
                    })
                }
            },
            {
                elem: 'toolbox',
                content: [
                    {
                        elem: 'multi',
                        tag: 'span',
                        elemMods: { mode: 'select' },
                        content: [
                            {
                                block: 'link',
                                mods: { pseudo: 'yes' },
                                mix: [{
                                    block: 'b-checklist',
                                    elem: 'select-all'
                                }],
                                content: iget2('b-checklist', 'vybrat-vse', 'выбрать все')
                            },
                            {
                                block: 'link',
                                mods: { pseudo: 'yes' },
                                mix: [{
                                    block: 'b-checklist',
                                    elem: 'reset'
                                }],
                                content: iget2('b-checklist', 'ochistit', 'очистить')
                            }
                        ]
                    },
                    {
                        block: 'input',
                        mix: [{
                            block: 'b-checklist',
                            elem: 'search-input'
                        }],
                        placeholder: this.ctx.searchPlaceholder || '',
                        content: [
                            {
                                elem: 'control'
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
