BEM.DOM.decl('b-checklist', {

    onSetMod: {

        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                searchInput: 'input on search-input',
                radiobox: 'radiobox on radiobox',
                selectAllLink: 'link on select-all',
                resetLink: 'link on reset'
            });

            this.searchInput.on('change', function() {
                this.filter(this.searchInput.val(), this._type);
            }, this);

            this._items = this.params.items || [];

            var nodesHash = this._nodesHash = {},
                _this = this;

            this.elem('item').each(function() {
                var node = $(this);

                nodesHash[_this.getMod(node, 'id')] = node;
            });

            var countSelected = 0;

            BEM.blocks['checkbox'].on(this.domElem, 'change', function(e) {
                countSelected += e.block.isChecked() ? 1 : -1;

                this.setMod(this.elem('multi'), 'mode', countSelected === this._items.length ? 'reset' : 'select');
            }, this);

            this.selectAllLink.on('click', this.selectAll, this);
            this.resetLink.on('click', this.reset, this);

            this.bindTo('item-label', 'click', function(e) {
                var item = e.data.domElem.closest(this.buildSelector('item'));

                if (this.getMod('mode') === 'multi') {
                    var checkbox = this.findBlockOn(this.findElem(item, 'item-checkbox'), 'checkbox');

                    checkbox.setMod('checked', checkbox.isChecked() ? '' : 'yes');
                } else {
                    this.radiobox.val(this.getMod(item, 'id'));
                }

            });
        }
    },

    /**
     * Устанавливает значение фильтра
     * @param {String} type
     */
    setItemTypeForFilter: function(type) {
        this._type = type;
        this.filter(this.searchInput.val(), this._type);
    },

    /**
     * Фильтрует список кампаний
     * @param {String} text – фрагмент заголовка или номера кампании
     * @param {String} type – значение фильтра
     */
    filter: function(text, type) {
        var highlightedTmpl = text && BEMHTML.apply({
                block: 'b-checklist',
                elem: 'highlighted',
                tag: 'span',
                content: '%STR%'
            }),
            fragment = this.elem('list').children().detach();

        //Фрагмент нужен для оптимизации отрисовски списка кампаний
        this._items.forEach(function(item) {
            var title = item.title,
                pos = title.toLowerCase().indexOf(text.toLowerCase()),
                itemDom = this._nodesHash[item.id];

            if (pos !== -1 || !text) {
                var newTitle = !text ?
                        title :
                        title.slice(0, pos) + highlightedTmpl.replace('%STR%', title.slice(pos, pos + text.length)) +
                            title.slice(pos + text.length);

                BEM.DOM.update(this.findElem(itemDom, 'item-title'), newTitle);
            }
            this.setMod(itemDom, 'hide', (pos === -1 || (type && !item.filters.includes(type))) ? 'yes' : '');
        }, this);

        fragment.appendTo(this.elem('list'));
    },

    /**
     * Выбирает все кампании в списке
     */
    selectAll: function() {
        this.findBlocksInside('checkbox')
            .forEach(function(checkbox) {
                if (!checkbox.isChecked()) {
                    checkbox.setMod('checked', 'yes');
                }
            });
    },

    /**
     * Сбрасывает выбор в списке кампаний
     */
    reset: function() {
        this.findBlocksInside({ block: 'checkbox', modName: 'checked', modVal: 'yes' }).forEach(function(checkbox) {
            checkbox.setMod('checked', '');
        });
    },

    /**
     * Возвращает массив идентификаторов выбранных кампаний
     * @returns {String[]}
     */
    getSelected: function() {
        return this.getMod('mode') === 'multi' ?
            this.findBlocksInside({ block: 'checkbox', modName: 'checked', modVal: 'yes' })
                .map(function(checkbox) {
                    return checkbox.domElem.closest(this.buildSelector('item'));
                }, this)
                .filter(function(item) {
                    return !this._type || !this.getMod(item, 'hide');
                }, this)
                .map(function(item) {
                    return this.getMod(item, 'id');
                }, this) :
                [this.radiobox.val()];
    },

    /**
     * Возвращает выбранные кампании
     * @returns {ReportFormCampaign[]}
     */
    getSelectedItems: function() {
        var ids = u._.indexBy(this.getSelected());

        return this.params.items.filter(function(item) {
            return ids[item.id];
        });
    },

    /**
     * Определяет сколько всего кампаний доступно
     * @returns {Boolean}
     */
    isOnlyOneItem: function() {
        return this._items.length === 1;
    }
});
