block('i-utils').match(function() {
    return this.utilsElem;
}).def()(function() {

    var DNA_TYPES_MAP = {
        text: 'TEXT',
        mobile_content: 'MOBILE_CONTENT',
        performance: 'PERFORMANCE',
        dynamic: 'DYNAMIC',
        mcbanner: 'MCBANNER',
        cpm_banner: 'CPM_BANNER',
        cpm_yndx_frontpage: 'CPM_YNDX_FRONTPAGE',
        cpm_deals: 'CPM_DEALS',
        content_promotion: 'CONTENT_PROMOTION',
        internal_distrib: 'INTERNAL_DISTRIB',
        internal_free: 'INTERNAL_FREE'
    };

    u.register({
        'b-choose-campaign-type': {

            /**
             * Возвращает доступные типы кампаний
             * @returns {String[]}
             */
            campaignTypes: function() {
                if (u.consts('rights').enableInternalCampaigns) {
                    return ['internal_distrib', 'internal_free'];
                }

                return [
                    'text',
                    u.consts('rights').createDynamicCampaigns && 'dynamic',
                    'mobile_content',
                    u.consts('rights').createDynamicMediaCampaigns && 'performance',
                    'mcbanner',
                    u.consts('rights').enableCpmCampaigns && 'cpm_banner',
                    u.consts('rights').enableCpmYndxFrontpageCampaigns && 'cpm_yndx_frontpage',
                    u.consts('rights').enableCpmDealsCampaigns && 'cpm_deals',
                    u.consts('rights').enableContentPromotion && 'content_promotion'
                ].filter(Boolean);
            }.bind(this),

            /**
             * Маппинг типов кампаний для DNA
             */
            dnaCampaignTypes: function() {
                return u['b-choose-campaign-type']
                    .campaignTypes()
                    .map(function(type) {
                        return DNA_TYPES_MAP[type];
                    })
            }.bind(this),

            getUrlParams: function(cmd, clientLogin, loginRights) {
                var urlParams = {
                        new_camp: 1
                    },
                    isManager = loginRights.manager_control,
                    isAgency = loginRights.agency_control,
                    addCampaignCmd = (loginRights.super_control || isManager || isAgency) ? 'stepZero' : 'editCamp';

                if (isManager && clientLogin && cmd === 'showClients') {
                    urlParams.for_agency = clientLogin;
                } else if ((isManager || isAgency) && clientLogin && cmd !== 'modifyUser') {
                    urlParams.for_client = clientLogin;
                } else if (loginRights.is_freelancer && clientLogin) {
                    urlParams.ulogin = clientLogin;
                }

                urlParams.cmd = addCampaignCmd;

                return urlParams;
            }.bind(this)
        }
    });

    return applyNext();
});
