BEM.DOM.decl('b-choose-campaign-type', {

    onSetMod: {
        js: function() {
            this._renderMenu();
        }
    },

    DNA_TYPES_MAP: {
        TEXT: 'text',
        MOBILE_CONTENT: 'mobile_content',
        PERFORMANCE: 'performance',
        DYNAMIC: 'dynamic',
        MCBANNER: 'mcbanner',
        CPM_BANNER: 'cpm_banner',
        CPM_YNDX_FRONTPAGE: 'cpm_yndx_frontpage',
        CPM_DEALS: 'cpm_deals',
        CONTENT_PROMOTION: 'content_promotion',
        INTERNAL_DISTRIB: 'internal_distrib',
        INTERNAL_FREE: 'internal_free'
    },

    /**
     * Рендерит список кампаний
     */
    _renderMenu: function() {
        var dna = window.dna;

        if (!dna) {
            return;
        }

        dna.reactDOMRender(
            dna.reactCreateElement(dna.components.CampaignTypesList, {
                availableCampaignTypes: this.params.campTypes,
                onClick: this._createCampaign.bind(this)
            }, null),
            this.elem('menu').get(0)
        );
    },

    /**
     * Делает запрос для отсылки отзыва пользователя о новом интефейсе
     */
    _createCampaign: function(dnaType, linkTarget) {
        var type = this.DNA_TYPES_MAP[dnaType],
            userLogin = this.params.userLogin || {},
            urlParams = Object.assign({}, this.params.urlParams, {
                mediaType: type
            }),
            addCampaignUrl;

        // При генерации статических страниц ошибок url ведет в продакшен
        // поэтому используем относительный url
        if (/^(errorPage)$/.test(u.consts('cmd'))) {
            addCampaignUrl = u.formatUrl({
                path: 'registered/main.pl',
                query: u._.extend(this.ctx.userLogin, urlParams)
            });
        } else {
            addCampaignUrl = u.getUrl(urlParams.cmd, u._.extend(userLogin, urlParams));
        }

        window.open(addCampaignUrl, linkTarget);
    }
});
