block('b-choose-country-currency')(

    def()(function() {
        return applyNext({
            'ctx.selectHint': this.ctx.selectHint || iget2('b-choose-country-currency', 'vyberite-iz-spiska', 'Выберите из списка...')
        });
    }),

    addJs()(function() {
        return {
            selectHint: this.ctx.selectHint,
            selectSize: this.ctx.size,
            currencySelectHint: this.ctx.currencySelectHint,
            currencySelectWidth: this.ctx.currencySelectWidth
        };
    }),

    content()(function() {
        var data = this.data,
            selectHint = this.ctx.selectHint,
            nameField = 'name_' + data.lang,
            mainCountries = [],
            otherCountries = [],
            countries = data.countries,
            currencies = data.countries_currencies,
            countriesCurrencies = {},
            inputNames = {
                countryInput: this.ctx.countryInputName || 'client_country',
                currencyInput: this.ctx.currencyInputName || 'client_currency'
            },
            ignoreCountrySelectData = this.ctx.ignoreSelectData || false;

        countries.forEach(function(country) {
            var main_country_priority = data.main_countries[country.region_id];

            if (main_country_priority) {
                country.priority = main_country_priority;
                mainCountries.push(country);
            } else {
                otherCountries.push(country);
            }
        });

        Object.keys(currencies).forEach(function(region_id) {
            var countryCurrencies = [];

            currencies[region_id].forEach(function(currency_code) {
                var currStr = u.currencies.getName(currency_code, {
                    full: 1
                });

                countryCurrencies.push({
                    code: currency_code,
                    title: currStr.charAt(0).toUpperCase() + currStr.slice(1)
                });
            });

            countriesCurrencies[region_id] = countryCurrencies;
        });

        return [
            {
                elem: 'country-hidden',
                attrs: {
                    type: 'hidden',
                    name: inputNames.countryInput,
                    value: ''
                }
            },
            {
                elem: 'currency-hidden',
                attrs: {
                    type: 'hidden',
                    name: inputNames.currencyInput,
                    value: ''
                }
            },
            {
                elem: 'row',
                content: [
                    {
                        elem: 'cell',
                        elemMods: { type: 'label' },
                        mix: [{
                            elem: 'country-label'
                        }],
                        content: iget2('b-choose-country-currency', 'vasha-strana', 'Ваша страна:')
                    },
                    {
                        elem: 'cell',
                        content: {
                            block: 'select',
                            mods: {
                                size: this.ctx.size || 's',
                                theme: 'normal',
                                layout: this.ctx.countrySelectWidth || 'fixed',
                                width: this.ctx.countrySelectWidth || '200',
                                disabled: this.data.cannot_request_currency_convert ? 'yes' : ''
                            },
                            mix: [{
                                block: 'b-choose-country-currency',
                                elem: 'country-select'
                            }],
                            // часть хака, что-бы сделать разделитель
                            // TODO: заменить на нормальную реализацию DIRECT-36758
                            js: {
                                popupMods: this.ctx.popupMods || {
                                    'separated-select': 'yes'
                                },
                                popupParams: this.ctx.selectPopupParams || {}
                            },
                            content: [
                                {
                                    block: 'button',
                                    content: selectHint
                                },
                                {
                                    elem: 'control',
                                    attrs: ignoreCountrySelectData && {
                                        disabled: 'disabled'
                                    },
                                    content: countries.length > 1 ?
                                        [
                                            {
                                                elem: 'option',
                                                attrs: {
                                                    disabled: 'disabled',
                                                    selected: 'selected',
                                                    value: ''
                                                },
                                                content: selectHint
                                            },
                                            mainCountries
                                                .sort(function(a, b) {
                                                    var termA = a.priority,
                                                        termB = b.priority;

                                                    return termA < termB ? -1 : termA == termB ? 0 : 1;
                                                })
                                                .map(function(c) {
                                                    return {
                                                        elem: 'option',
                                                        attrs: {
                                                            value: c.region_id
                                                        },
                                                        content: c[nameField]
                                                    };
                                                }),
                                            // пришлось захачить пустой группой, иначе разделитель не сделать
                                            // TODO: заменить на нормальную реализацию DIRECT-36758
                                            {
                                                elem: 'option-group',
                                                attrs: {
                                                    label: ' '
                                                },
                                                content: [
                                                    // нужна хотя бы одна опция,
                                                    // иначе появится еще одни разделитель в самом низу
                                                    {
                                                        elem: 'option',
                                                        attrs: {
                                                            disabled: 'disabled'
                                                        },
                                                        content: '-'
                                                    }
                                                ]
                                            },
                                            otherCountries
                                                .sort(function(a, b) {
                                                    var termA = a[nameField].toLowerCase(),
                                                        termB = b[nameField].toLowerCase();

                                                    return termA < termB ? -1 : termA == termB ? 0 : 1;
                                                })
                                                .map(function(c) {
                                                    return {
                                                        elem: 'option',
                                                        attrs: {
                                                            value: c.region_id
                                                        },
                                                        content: c[nameField]
                                                    };
                                                })
                                        ] :
                                        [
                                            {
                                                elem: 'option',
                                                attrs: {
                                                    disabled: 'disabled',
                                                    selected: 'selected',
                                                    value: ''
                                                },
                                                content: selectHint
                                            },
                                            {
                                                elem: 'option',
                                                attrs: {
                                                    value: countries[0].region_id
                                                },
                                                content: countries[0][nameField]
                                            }
                                        ]
                                }
                            ]
                        }
                    }
                ]
            },
            {
                elem: 'row',
                mix: {
                    block: 'b-choose-country-currency',
                    elem: 'currency-type-row'
                },
                content: [
                    {
                        elem: 'cell',
                        elemMods: { type: 'label' },
                        mix: [{
                            elem: 'currency-label'
                        }],
                        content: iget2('b-choose-country-currency', 'valyuta-akkaunta', 'Валюта аккаунта:')
                    },
                    {
                        elem: 'cell',
                        mix: [{
                            elem: 'currency-selectnode'
                        }],
                        content: {
                            elem: 'currency-type',
                            js: countriesCurrencies,
                            content: iget2('b-choose-country-currency', 'vyberite-vashu-stranu', 'Выберите вашу страну')
                        }
                    }
                ]
            }
        ];
    })
);
