BEM.DOM.decl('b-choose-country-currency', {

    onSetMod: {
        js: function() {
            var countrySelect = this._getCountrySelect();

            this._selectHint = this.params.currencySelectHint || this._selectHint;

            countrySelect.on('change', function(e) {
                var val = e.block.val();

                this._updateCurrenciesSelect(val);
                this._updateCountryHidden(val);

            }, this);
        }
    },

    _selectHint: iget2('b-choose-country-currency', 'vyberite-iz-spiska', 'Выберите из списка...'),

    /**
     * @private
     * @type {BEM}
     */
    _currencySelect: null,

    /**
     * Пишет спан с единственным доступным вариантом
     * @param {String} option содержимое спана
     * @returns {BEM}
     */
    _renderCurrencySpan: function(option) {
        option = option || {
            title: iget2('b-choose-country-currency', 'ne-ukazana', 'Не указана')
        };

        BEM.DOM.update(
            this.elem('currency-type'),
            BEMHTML.apply({
                block: 'b-choose-country-currency',
                elem: 'currency-singleopt',
                content: option.title
            }));

        this.trigger('currencyChanged', { currencyCode: option.code });
        this.elem('currency-hidden').val(option.code);
        this._currencySelect = null;
    },

    /**
     * Возвращает селект с валютой
     * @returns {BEM}
     */
    _getCurrencySelect: function() {
        return this._currencySelect || (this._currencySelect = this._createCurrencySelect());
    },

    /**
     * @private
     * @type {BEM}
     */
    _countrySelect: null,

    /**
     * Возвращает селект со страной
     * @returns {BEM}
     */
    _getCountrySelect: function() {
        return this._countrySelect || (this._countrySelect = this.findBlockOn('country-select', 'select'));
    },

    /**
     * Создаем селект с выбором валюты
     * @returns {BEM}
     */
    _createCurrencySelect: function() {
        var size = this.params.selectSize || 's',
            html = $(BEMHTML.apply({
                block: 'select',
                mods: {
                    size: size,
                    theme: 'normal',
                    layout: 'fixed',
                    width: this.params.currencySelectWidth || '200'
                },
                mix: [{ block: 'b-choose-country-currency', elem: 'currency-select' }],
                content: [
                    {
                        block: 'button',
                        content: this._selectHint
                    },
                    {
                        elem: 'control',
                        mods: { disabled: 'true' },
                        content: {
                            elem: 'option',
                            attrs: { disabled: 'disabled', value: '' },
                            content: this._selectHint
                        }
                    }
                ]
            }));

        BEM.DOM.update(this.elem('currency-type'), html);

        return html.bem('select').on('change', function(e) {
            this.elem('currency-hidden').val(e.block.val());
            this.trigger('currencyChanged', { currencyCode: e.block.val() });
        }, this);
    },

    /**
     * Обновляем скрытый инпут со страной
     * @param {Number} country код страны
     */
    _updateCountryHidden: function(country) {
        this.elem('country-hidden').val(country);
        this.trigger('countryChanged', { countryId: country });
        country === '225' && this.trigger('chooseRussia');
    },

    /**
     * Обновляем список валют
     * @param {Number} country
     */
    _updateCurrenciesSelect: function(country) {
        var countriesCurrencies = this.elemParams('currency-type'),
            currencyList = countriesCurrencies[country] || [],
            options = [{
                item: 'option',
                disabled: 'disabled',
                selected: 'selected',
                value: '',
                content: this._selectHint
            }];

        if (currencyList.length > 1) {
            currencyList.forEach(function(currency) {
                options.push({
                    item: 'option',
                    value: currency.code,
                    content: currency.title
                });
            });

            this._getCurrencySelect().setOptions(options);
        } else {
            this._renderCurrencySpan(currencyList[0]);
        }
    }
});
