block('b-client-wallet').elem('email-notice')(

    content()(function() {
        var wallet = this.ctx.wallet,
            emailPopup = applyCtx({
                block: 'b-email-select',
                js: {
                    id: 'email-select'
                },
                content: {
                    elem: 'popup-block'
                }
            }),
            emailSelect = applyCtx({
                block: 'b-email-select',
                js: {
                    id: 'email-select',
                    modelName: 'm-email-select',
                    options: wallet.validEmails.map(function(val) {
                        return {
                            item: 'option',
                            value: val.email,
                            content: val.email
                        };
                    })
                },
                content: {
                    elem: 'select-block',
                    email: wallet.email,
                    validEmails: wallet.validEmails
                }
            });

        return [
            {
                block: 'b-outboard-controls',
                mods: { 'save-type': 'ajax' },
                cmd: 'ajaxSaveWalletSettings',
                params: {
                    cid: wallet.wallet_cid,
                    ulogin: u.consts('ulogin')
                },
                content: [
                    {
                        block: 'button',
                        mods: {
                            theme: 'normal',
                            disabled: this.mods.readonly || this.isNotificationDisabled ? 'yes' : ''
                        },
                        js: true,
                        mix: [
                            {
                                block: 'b-outboard-controls',
                                elem: 'switcher'
                            }
                        ],
                        content: iget2('b-client-wallet', 'nastroit', 'Настроить')
                    },
                    {
                        elem: 'popup',
                        header: iget2('b-client-wallet', 'nastroyka-polucheniya-uvedomleniy', 'Настройка получения уведомлений'),
                        innerBlock: applyCtx({
                            block: 'b-email-notification',
                            options: wallet,
                            emailSelect: emailSelect
                        })
                    },
                    emailPopup
                ]
            }
        ];
    })
);
