block('b-client-wallet').elem('row-auto-payment')(

    mix()([
        { elem: 'row' },
        { elem: 'row-auto-payment' }
    ]),

    content()(function() {

        return [
            {
                block: 'b-client-wallet',
                elem: 'col-name',
                content: [
                    iget2('b-client-wallet', 'autopayment', 'Автоплатёж'),
                    {
                        block: 'b-help-link',
                        mods: { type: 'modal', decoration: 'no' },
                        url: u.getHelpUrl('shared-account')
                    }
                ]
            },
            {
                block: 'b-autopayment-info',
                mix: { block: 'b-client-wallet', elem: 'col-val' },
                autoPaySettings: this.ctx.autopaySettings,
                canResumeAutopay: u.autopayment.params.canResumeAutopay,
                disableEditAutopay: true,
                currency: this.ctx.currency
            },
            !u.autopayment.params.disableEditAutopay && {
                elem: 'col-act',
                content: {
                    block: 'button',
                    mods: {
                        theme: 'normal',
                        size: 's',
                        disabled: this.ctx.isCommonWalletDisabled ? 'yes' : ''
                    },
                    url: u.autopayment.getPageUrl({ retpath: u.getCurrentUrl() }),
                    content: iget2('b-client-wallet', 'nastroit', 'Настроить')
                }
            }
        ];
    })
);
