block('b-client-wallet').elem('row-bonus')(

    mix()({ elem: 'row' }),

    content()(function() {
        var ctx = this.ctx,
            currency = ctx.currency,
            isBonusVoid = !ctx.bonusSum,
            isCashbackPageEnabled = this.data.isCashbackAvailable == 1,
            formattedBonusSum = u.currencies.formatSum(
                currency,
                ctx.bonusSum
            ),
            primaryLabel,
            secondaryLabel;

        if (isBonusVoid) {
            primaryLabel = iget2('b-client-wallet', 'bonus-program', 'Бонусная программа');
            secondaryLabel = null;
        } else if (isCashbackPageEnabled) {
            primaryLabel = iget2('b-client-wallet', 'bonus2', 'Бонусы, ожидающие зачисления');
            secondaryLabel = iget2('b-client-wallet', 'top-up-to-get-bonus', 'Пополните счёт на любую сумму, чтобы они зачислились')
        } else {
            primaryLabel = iget2('b-client-wallet', 'bonus', 'Начислено бонусов');
            secondaryLabel = iget2('b-client-wallet', 'bonus-description', 'за весь период программы');
        }

        return [
            {
                elem: 'col-name',
                content: [
                    {
                        elem: 'bonus-col-name',
                        content: primaryLabel
                    },
                    secondaryLabel
                ]

            },
            {
                elem: 'col-val',
                mix: {
                    elem: 'bonus-col-val'
                },
                content: isBonusVoid ? null : [
                    {
                        elem: 'price-without-nds',
                        content: formattedBonusSum
                    }
                ]
            },
            isCashbackPageEnabled && {
                elem: 'col-act',
                mix: {
                    elem: 'bonus-col-act'
                },
                content: [
                    {
                        block: 'button2',
                        mods: {
                            theme: 'link',
                            type: 'link',
                            view: 'default',
                            size: 's'
                        },
                        mix: {
                            block: 'b-pay',
                            elem: 'cashback-page-link'
                        },
                        url: u.formatUrl({
                            path: '/dna/bonus',
                            query: {
                                ulogin: u.consts('ulogin')
                            }
                        }),
                        target: '_blank',
                        text: iget2('b-client-wallet', 'further-link', 'Подробнее')
                    },
                ]
            }
        ]
    })
);
