block('b-client-wallet').elem('row-daily-budget')(

    mix()({ elem: 'row' }),

    content()(function() {
        var wallet = this.ctx.wallet,
            preYear,
            campStopDailyBudgetStats = wallet.camp_stop_daily_budget_stats
                .reduce(
                    function(result, item) {
                        var year;

                        item = u.moment(item);

                        if (!item.isValid()) {
                            return result;
                        }

                        year = item.year();

                        if (year !== preYear) {
                            result.push({
                                block: 'b-client-wallet',
                                elem: 'daily-budget-stop-year',
                                content: year
                            });

                            preYear = year;
                        }

                        result.push({
                            block: 'b-client-wallet',
                            elem: 'daily-budget-stop-item',
                            content: [
                                {
                                    block: 'b-client-wallet',
                                    elem: 'daily-budget-stop-item-date',
                                    content: item.format('DD.MM')
                                },
                                {
                                    block: 'b-client-wallet',
                                    elem: 'daily-budget-stop-item-time',
                                    content: item.format('HH:mm')
                                }
                            ]
                        });

                        return result;
                    }, []);

        return [
            {
                elem: 'col-name',
                content: [
                    iget2('b-client-wallet', 'dnevnoy-byudzhet', 'Дневной бюджет'),
                    {
                        block: 'b-help-link',
                        mods: { type: 'modal', decoration: 'no' },
                        url: u.getHelpUrl('shared-account-day-budget')
                    }
                ]
            },
            {
                elem: 'col-val',
                mix: {
                    elem: 'model-field',
                    js: [
                        {
                            name: 'dayBudgetSumText',
                            type: 'inline'
                        }
                    ]
                },
                content: +this.ctx.wallet.day_budget.sum ?
                    u.currencies.formatSum(this.ctx.currency, this.ctx.wallet.day_budget.sum) :
                    iget2('b-client-wallet', 'ne-zadan', 'не задан')
            },
            {
                elem: 'col-act',
                content: [
                    {
                        block: 'button',
                        mods: {
                            size: 's',
                            disabled: this.mods.readonly || this.isDailyBudgetDisabled ? 'yes' : ''
                        },
                        content: iget2('b-client-wallet', 'nastroit', 'Настроить')
                    },
                    {
                        block: 'popup',
                        mods: {
                            autoclosable: 'yes',
                            'has-close': 'yes',
                            common: 'yes'
                        },
                        mix: {
                            block: 'b-client-wallet',
                            elem: 'day-budget-popup'
                        },
                        js: {
                            directions: ['bottom', 'top']
                        },
                        content: [
                            { elem: 'tail' },
                            { elem: 'content' }
                        ]
                    }
                ]
            },
            {
                block: 'dropdown',
                mix: {
                    block: 'b-client-wallet',
                    elem: 'daily-budget-hint'
                },
                content: [
                    {
                        block: 'link',
                        mods: {
                            theme: 'normal',
                            disabled: !campStopDailyBudgetStats.length ? 'yes' : ''
                        },
                        content: iget2('b-client-wallet', 'ostanovki-za-poslednee-vremya', 'Остановки за последнее время'),
                        mix: {
                            block: 'dropdown',
                            elem: 'switcher'
                        }
                    },
                    {
                        block: 'b-client-wallet',
                        elem: 'hint',
                        content: iget2('b-client-wallet', 'utc-3-moskovskoe-vremya', '(UTC+3, московское время)')
                    },
                    {
                        elem: 'popup',
                        mix: { block: 'b-client-wallet', elem: 'daily-budget-popup-content' },
                        js: { directions: 'bottom' },
                        content: {
                            block: this.block,
                            elem: 'daily-budget-stop',
                            content: campStopDailyBudgetStats
                        }
                    }
                ]
            }
        ];
    })
);
