block('b-client-wallet').elem('row-debt')(

    mix()(function() {
        var ctx = this.ctx,
            paymentOverdue = u.moment(ctx.debtDate).isBefore(u.moment());

        return {
            elem: 'row',
            elemMods: {
                'payment-overdue': paymentOverdue ? 'yes' : ''
            }
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            data = this.data,
            paymentOverdue = u.moment(ctx.debtDate).isBefore(u.moment()),
            debtDateText = paymentOverdue ? iget2(
                'b-client-wallet',
                'debt-date-overdue',
                'Срок погашения просрочен {date}',
                {
                    date: u.moment(ctx.debtDate).format('DD.MM.YYYY')
                }
            ) : iget2(
                'b-client-wallet',
                'debt-date',
                'Необходимо погасить до {date}',
                {
                    date: u.moment(ctx.debtDate).format('DD.MM.YYYY')
                }
            );

        return [
            {
                elem: 'col-name',
                mix: {
                    elem: 'row-debt-col-name'
                },
                content: [
                    {
                        content: iget2('b-client-wallet', 'row-debt', 'Задолженность')
                    },
                    {
                        elem: 'debt-date',
                        content: debtDateText
                    }
                ]
            },
            {
                elem: 'col-val',
                mix: [
                    {
                        elem: 'row-debt-col-val'
                    }
                ],
                content: [
                    {
                        elem: 'debt-without-nds',
                        content: ctx.debt
                    },
                    {
                        elem: 'debt-with-nds',
                        content: !ctx.wallet.is_fake_nds && ctx.debtWithNds
                    }
                ]
            },
            {
                elem: 'col-act',
                mix: {
                    elem: 'row-debt-col-act'
                },
                content: {
                    block: 'button2',
                    url: u.formatUrl({
                        host: u.consts('balance'),
                        // todo поправить вызов u.formatUrl на корректную работу с параметрами
                        // (нужно сдвинуть ревизию adv-blocks чтобы u.formatUrl не срезал параметры с нулём)
                        path: '/invoices.xml?date_type=1&receipt_status=0&payment_type=1' +
                        (data.login_rights.role.match(/manager|support|superreader|super/) ?
                            '&client_id=' + ctx.wallet.clientID :
                            '')
                    }),
                    mods: {
                        theme: 'normal',
                        size: 's',
                        type: 'link'
                    },
                    mix: [
                        {
                            block: 'b-client-wallet',
                            elem: 'row-debt-popup-opener'
                        }
                    ],
                    text: iget2('b-client-wallet', 'pogasit', 'Погасить')
                }
            }
        ]
    })
);
