block('b-client-wallet').elem('row-remain')(

    mix()({ elem: 'row' }),

    content()(function() {
        var ctx = this.ctx,
            data = this.data,
            wallet = ctx.wallet,
            isNdsAvailable = !ctx.wallet.is_fake_nds,
            newPaymentWorkflow = data.new_payment_workflow_enabled,
            clientFeaturesAll = u.consts('clientFeaturesAll'),
            isPaymentRedesignEnabled = clientFeaturesAll.includes('PAYMENT_REDESIGN_ENABLED_FOR_DNA') && clientFeaturesAll.includes('PAYMENT_REDESIGN_ENABLED_FOR_OLD_WALLET'),
            isShowDnaPayment = newPaymentWorkflow && isPaymentRedesignEnabled;

        return [
            {
                elem: 'col-name',
                mix: {
                    elem: 'remain-col-name'
                },
                content: iget2('b-client-wallet', 'wallet-remaining-sum', 'Остаток на счёте')
            },
            {
                elem: 'col-val',
                mix: {
                    elem: 'remain-col-val'
                },
                content: [
                    {
                        elem: 'remain-without-nds',
                        content: u.currencies.formatSum(ctx.client.currentCurrency, wallet.total)
                    },
                    {
                        elem: 'remain-with-nds',
                        content: isNdsAvailable && iget2(
                            'b-client-wallet',
                            'positive-nds-sum',
                            '{sum} с НДС',
                            {
                                sum: u.currencies.formatSum(ctx.client.currentCurrency, wallet.total_with_nds)
                            }
                        )
                    }
                ]
            },
            {
                elem: 'col-act',
                content: [
                    {
                        block: isShowDnaPayment ? 'b-pay-dna' : 'b-pay',
                        mix: [
                            { block: 'b-client-wallet', elem: 'payment-form' }
                        ],
                        mods: {
                            nds: +ctx.client.nds &&
                            !u._.contains(['YND_FIXED', 'BYN', 'KZT'], ctx.client.currentCurrency) ? 'yes' : 'no',
                            disabled: this.mods.readonly || this.isPaymentDisabled ? 'yes' : ''
                        },
                        wallet: wallet,
                        clientNDS: ctx.client.nds,
                        userLogin: u.consts('ulogin'),
                        cid: wallet.wallet_cid,
                        offerSumToPay: wallet.offer_sum_to_pay,
                        isOfferAccepted: this.data.is_offer_accepted
                    }
                ]
            }
        ]
    })
);
