block('b-client-wallet').elem('row-switch-off-limit')(

    mix()(function() {
        var ctx = this.ctx,
            switchOffLimitInfo = ctx.switchOffLimitInfo;

        return [
            {
                elem: 'row',
            },
            {
                elem: 'row-switch-off-limit',
                elemMods: {
                    'limit-used': switchOffLimitInfo.value > 0 ? 'yes' : ''
                }
            }
        ];
    }),

    content()(function() {
        var ctx = this.ctx,
            switchOffLimitInfo = ctx.switchOffLimitInfo,
            isNdsAvailable = ctx.switchOffLimitInfo.isNdsAvailable,
            valueWithoutNds = switchOffLimitInfo.value === 0 ?
                u.currencies.formatSum(ctx.currency, switchOffLimitInfo.value) :
                '\u2013 ' + u.currencies.formatSum(ctx.currency, switchOffLimitInfo.value),
            valueWithNds = (switchOffLimitInfo.valueWithNds === 0 ?
                u.currencies.formatSum(ctx.currency, switchOffLimitInfo.valueWithNds) :
                '\u2013 ' + u.currencies.formatSum(ctx.currency, switchOffLimitInfo.valueWithNds)) + ' ' + iget2(
                'b-client-wallet',
                'with-nds',
                'с НДС'
            ),
            shortHint = isNdsAvailable ? iget2(
                'b-client-wallet',
                'switch-off-limit-short-hint2',
                'Можно настроить порог до –{switchOffLimit} с НДС',
                {
                    switchOffLimit: u.currencies.formatSum(ctx.currency, switchOffLimitInfo.maxValue, { delim: '&nbsp;' } )
                }
            ) : iget2(
                'b-client-wallet',
                'switch-off-limit-short-hint-without-nds2',
                'Можно настроить порог до –{switchOffLimit}',
                {
                    switchOffLimit: u.currencies.formatSum(ctx.currency, switchOffLimitInfo.maxValue, { delim: '&nbsp;' } )
                }
            ),
            longHint = [
                isNdsAvailable ? iget2(
                    'b-client-wallet',
                    'switch-off-limit-hint-2',
                    'Ваши кампании будут остановлены, когда баланс общего счёта достигнет {overdraftLimit}',
                    {
                        overdraftLimit: u.currencies.formatSum(ctx.currency, switchOffLimitInfo.value, { delim: '&nbsp;' } ),
                    }
                ) : iget2(
                    'b-client-wallet',
                    'switch-off-limit-hint-without-nds-2',
                    'Ваши кампании будут остановлены, когда баланс общего счёта достигнет {overdraftLimit}',
                    {
                        overdraftLimit: u.currencies.formatSum(ctx.currency, switchOffLimitInfo.value, { delim: '&nbsp;' } ),
                    }
                ),
                '</br>',
                isNdsAvailable ? iget2(
                    'b-client-wallet',
                    'switch-off-limit-nds2',
                    'Вы можете настроить порог до –{switchOffLimit} (-{switchOffLimitWithNds} с НДС)',
                    {
                        switchOffLimit: u.currencies.formatSum(ctx.currency, switchOffLimitInfo.maxValueWithoutNds, { delim: '&nbsp;' } ),
                        switchOffLimitWithNds: u.currencies.formatSum(ctx.currency, switchOffLimitInfo.maxValue, { delim: '&nbsp;' } )
                    }
                ) : iget2(
                    'b-client-wallet',
                    'switch-off-limit-hint-no-nds2',
                    'Вы можете настроить порог до –{switchOffLimit}',
                    {
                        switchOffLimit: u.currencies.formatSum(ctx.currency, switchOffLimitInfo.maxValueWithoutNds, { delim: '&nbsp;' } ),
                    }
                )
            ];

        return [
            {
                elem: 'col-name',
                mix: {
                    elem: 'switch-off-limit-col-name'
                },
                content: [
                    iget2('b-client-wallet', 'switch-off-limit2', 'Порог отключения показов'),
                    {
                        elem: 'switch-off-limit-hint-description',
                        content: [
                            ctx.switchOffLimitInfo.maxValueWithoutNds !== 0 && shortHint,
                            {
                                block: 'b-help-link',
                                mods: { type: 'modal', decoration: 'no' },
                                url: u.getHelpUrl('overdraft-limit')
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'col-val',
                content: [
                    {
                        block: 'b-client-wallet',
                        elem: 'switch-off-limit-limit-without-nds',
                        content: valueWithoutNds,
                        mix: [
                            {
                                elem: 'switch-off-limit-col-val'
                            },
                            {
                                elem: 'model-field',
                                js: [
                                    {
                                        name: 'switchOffLimitText',
                                        type: 'inline'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        block: 'b-client-wallet',
                        elem: 'switch-off-limit-limit-with-nds',
                        content: isNdsAvailable && valueWithNds,
                        mix: [
                            {
                                elem: 'switch-off-limit-col-val'
                            },
                            {
                                elem: 'model-field',
                                js: [
                                    {
                                        name: 'switchOffLimitTextWithNds',
                                        type: 'inline'
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'col-act',
                mix: {
                    elem: 'switch-off-limit-col-act',

                },
                content: {
                    elem: 'switch-off-limit-popup-opener-wrapper',
                    content: {
                        block: 'button2',
                        mods: {
                            theme: 'pseudo',
                            size: 's',
                            disabled: this.mods.readonly || ctx.isCommonWalletDisabled || !switchOffLimitInfo.isEditable ? 'yes' : '',
                        },
                        mix: [
                            {
                                block: 'b-client-wallet',
                                elem: 'switch-off-limit-popup-opener'
                            }
                        ],
                        text: iget2('b-client-wallet', 'nastroit', 'Настроить')
                    },
                    mix: [
                        !switchOffLimitInfo.isEditable && {
                            block: 'b-hintable',
                            js: {
                                hint: iget2(
                                        'b-client-wallet',
                                        'disabled-switch-off-limit-disabled-hint2',
                                        'Настройка порога отключения показов недоступна, поскольку не выполнены условия предоставления отсрочки платежа. Своевременно пополняйте общий счет, чтобы избежать остановки кампаний.'
                                    )
                            },
                            mods: { hoverable: 'yes' }
                        }
                    ]
                }
            },
            {
                elem: 'switch-off-limit-hint',
                content: [
                    {
                        elem: 'switch-off-limit-hint-text',
                        mix: {
                            elem: 'model-field',
                            js: [
                                {
                                    name: 'switchOffLimitHintText',
                                    type: 'inline'
                                }
                            ]
                        },
                        content: switchOffLimitInfo.value <= 0 && longHint
                    }
                ]
            }
        ]
    })
);
