/**
 * Общий счет
 * @param {Object} ctx.client данные клиента
 * @param {Object} ctx.autopaySettings настройки автоплатежа
 * @param {Object} ctx.wallet кошелек
 * @param {Boolean} ctx.switchOffLimitInfo.isEditable флаг доступности редактирования порога отключения
 * @param {Object} ctx.switchOffLimitInfo данные порога отключения
 * @param {Number} ctx.switchOffLimitInfo.value заданное клиентом значение
 * @param {Number} ctx.switchOffLimitInfo.minValue минимальное значение, возможное для задания прога отключения
 * @param {Number} ctx.switchOffLimitInfo.maxValue максимальное значение, возможное для задания прога отключения
 */
block('b-client-wallet')(

    def()(function() {
        var walletRestr = this.ctx.walletRestrictions;

        return applyNext({
            'mods.readonly': walletRestr.isReadOnlyWallet ? 'yes' : '',
            isCommonWalletDisabled: !this.ctx.wallet.enabled,
            isDailyBudgetDisabled: !(walletRestr.isAllowTransferMoney || walletRestr.isAllowedEditCamps),
            isNotificationDisabled: !walletRestr.isAllowedEditCamps,
            isPaymentDisabled: !walletRestr.isAllowedPay,
            needSubscription: !walletRestr.isAllowedPay && walletRestr.needOnlyCampModerationToPay
        })
    }),

    addJs()(function() {
        var ctx = this.ctx,
            wallet = ctx.wallet;

        return {
            modelName: 'b-client-wallet',
            modelData: {
                clientNDS: ctx.client.nds,
                currentCurrency: ctx.client.currentCurrency,
                isCommonWalletDisabled: this.isCommonWalletDisabled,
                remainValue: +wallet.total,
                email: wallet.email,
                smsPhone: wallet.sms_phone,
                dayBudgetSum: +wallet.day_budget.sum,
                dayBudgetShowMode: wallet.day_budget.show_mode,
                switchOffLimit: ctx.switchOffLimitInfo.value,
                switchOffLimitMaxValue: ctx.switchOffLimitInfo.maxValueWithoutNds,
                switchOffLimitMaxValueWithNds: ctx.switchOffLimitInfo.maxValue,
                isNdsAvailable: !ctx.wallet.is_fake_nds,
                switchOffLimitResetEnabled: ctx.switchOffLimitInfo.resetEnabled,
                switchOffLimitWithNds: ctx.switchOffLimitInfo.valueWithNds
            },
            cid: wallet.wallet_cid,
            showEditTools: ctx.showEditTools,
            ulogin: u.consts('ulogin'),
            csrf_token: u.consts('csrf_token'),
            switchOffLimitMinSum: ctx.switchOffLimitInfo.minValue,
            switchOffLimitMaxSum: ctx.switchOffLimitInfo.maxValue,
            switchOffLimitResetEnabled: ctx.switchOffLimitInfo.resetEnabled
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            wallet = ctx.wallet,
            client = ctx.client,
            currentCurrency = client.currentCurrency,
            isNdsAvailable = ctx.switchOffLimitInfo.isNdsAvailable,
            isCashbackPageEnabled = this.data.isCashbackAvailable == 1,
            bonusSum = wallet.cashback_bonus && wallet.cashback_bonus.awaitingSum;

        return [
            {
                elem: 'section',
                content: [
                    {
                        elem: 'row-remain',
                        client: client,
                        wallet: wallet,
                        isCommonWalletDisabled: this.isCommonWalletDisabled
                    },
                    (bonusSum > 0 || isCashbackPageEnabled) && {
                        elem: 'row-bonus',
                        currency: currentCurrency,
                        bonusSum: bonusSum
                    },
                    this.needSubscription && {
                        block: 'b-client-wallet',
                        elem: 'warning',
                        content: [
                            {
                                elem: 'warning-icon',
                            },
                            {
                                elem: 'warning-hint',
                                content: iget2(
                                    'b-client-wallet',
                                    'popolnit-os-mozhno-tolko-posle',
                                    'Пополнить общий счёт можно только после того, как хотя бы одна кампания пройдёт модерацию'
                                )
                            }
                        ]
                    },
                ]
            },
            (wallet.overdraft_lim > 0 || wallet.debt > 0) && {
                elem: 'section',
                content: [
                    wallet.overdraft_lim > 0 && {
                        elem: 'row-available-pay-delay',
                        availablePayDelay: iget2(
                            'b-client-wallet',
                            'up-to-sum',
                            'до {sum}',
                            {
                                sum: u.currencies.formatSum(
                                    currentCurrency,
                                    wallet.overdraft_lim
                                )
                            }
                        ),
                        availablePayDelayWithNds: isNdsAvailable && iget2(
                            'b-client-wallet',
                            'up-to-sum',
                            'до {sum}',
                            {
                                sum: iget2(
                                    'b-client-wallet',
                                    'positive-nds-sum',
                                    '{sum} с НДС',
                                    {
                                        sum: u.currencies.formatSum(
                                            currentCurrency,
                                            wallet.overdraft_lim_with_nds
                                        )
                                    }
                                )
                            }
                        )
                    },
                    {
                        elem: 'row-switch-off-limit',
                        currency: currentCurrency,
                        isCommonWalletDisabled: this.isCommonWalletDisabled,
                        switchOffLimitInfo: ctx.switchOffLimitInfo,
                        isNdsAvailable: ctx.switchOffLimitInfo.isNdsAvailable,
                        switchOffLimitMaxValueWithNds: ctx.switchOffLimitMaxValueWithNds
                    },
                    wallet.debt > 0 && {
                        elem: 'row-debt',
                        debt: u.currencies.formatSum(currentCurrency, wallet.debt),
                        wallet: wallet,
                        debtWithNds: isNdsAvailable && iget2(
                            'b-client-wallet',
                            'positive-nds-sum',
                            '{sum} с НДС',
                            {
                                sum: u.currencies.formatSum(currentCurrency, wallet.debt_with_nds)
                            }
                        ),
                        debtDate: wallet.nextPayDate
                    }
                ]
            },
            {
                elem: 'section',
                content: [
                    {
                        elem: 'row-daily-budget',
                        wallet: wallet,
                        currency: currentCurrency,
                        isCommonWalletDisabled: this.isCommonWalletDisabled
                    },
                    !u.autopayment.params.disabled && ctx.autopaySettings.autopay_mode && {
                        elem: 'row-auto-payment',
                        autopaySettings: ctx.autopaySettings,
                        currency: currentCurrency,
                        isCommonWalletDisabled: this.isCommonWalletDisabled
                    }
                ]
            },
            {
                elem: 'section',
                content: [
                    {
                        elem: 'row-email',
                        wallet: wallet
                    },
                    {
                        elem: 'row-sms',
                        wallet: wallet
                    }
                ]
            }
        ];
    })
);
