BEM.DOM.decl({ name: 'b-client-wallet', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._initDayBudget();
            this._initNoticeSettingsControls();
            this._initSwitchOffLimitControls();
            this._initBPaySubscription();
        }
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    showSwitchOffLimitPopup: function(amount) {
        var dna = window.dna,
            model = this.model,
            params = this.params,
            switchOffRow = this.findElem('row-switch-off-limit'),
            originalAmount = model.get('switchOffLimitWithNds');

        if (switchOffRow.length === 0) {
            return;
        }

        if (amount !== undefined) {
            model.set('switchOffLimitWithNds', amount);
        }

        // не очищаем в обработчике onClose, так как в случае ошибки нужно закрыть попап и показать алерт из dna
        if (this._switchOffLimitPopup) {
            BEM.DOM.destruct(this._switchOffLimitPopup);
        }

        try {
            this._switchOffLimitPopup = BEM.DOM.append(switchOffRow, BEMHTML.apply({
                block: 'b-client-wallet',
                elem: 'switch-off-limit-popup'
            }));

            dna.reactDOMRender(
                dna.reactCreateElement(dna.components.WalletSwitchOffLimitEditPopupWrapper, {
                    login: params.ulogin,
                    sum: Number(model.get('switchOffLimitWithNds')),
                    minSum: Number(params.switchOffLimitMinSum),
                    maxSum: Number(params.switchOffLimitMaxSum),
                    currency: model.get('currentCurrency'),
                    canResetLimit: model.get('switchOffLimitResetEnabled') && model.get('switchOffLimitWithNds') > 0,
                    isVisible: true,
                    isNdsActive: model.get('isNdsAvailable'),
                    onClose: function() {
                        if (amount !== undefined) {
                            model.set('switchOffLimitWithNds', originalAmount);
                        }
                        this._onSwitchOffLimitPopupClose();
                    }.bind(this),
                    onReset: this._onSwitchOffLimitReset.bind(this),
                    onSet: this._onSwitchOffLimitSet.bind(this)
                }, null),
                this._switchOffLimitPopup[0]
            );
        } catch (err) {
            BEM.blocks['b-user-dialog'].alert({
                message: iget2('b-client-wallet', 'dna-loading-failt', 'Что-то пошло не так')
            });
        }
    },

    /**
     * Инициализирует блок настроек порога отключения
     */
    _initSwitchOffLimitControls: function() {
        var switchOffLimitPopupOpener = this.findBlockOn('switch-off-limit-popup-opener', 'button2'),
            dna = window.dna;

        if (!switchOffLimitPopupOpener || !dna) {
            return;
        }

        this._subscriptionManager.on(
            switchOffLimitPopupOpener,
            'click',
            function() { this.showSwitchOffLimitPopup(); },
            this
        );
    },

    /**
     * Обработчик события закрытия попапа редактирования порога отключения
     */
    _onSwitchOffLimitPopupClose: function() {
        BEM.DOM.destruct(this._switchOffLimitPopup);
    },

    /**
     * Обработчик события установки порога отключения
     * @param {Object} limitSettings
     * @param {Number} limitSettings.sum значение порога отключения
     * @param {String} limitSettings.payerId идентификатор плательщика
     * @param {String} limitSettings.paymentMethodId идентификатор способа оплаты
     */
    _onSwitchOffLimitSet: function(limitSettings) {
        this.setMod(this.elem('switch-off-limit-hint'), 'hidden', 'yes');
        this.model.update({
            switchOffLimit: limitSettings.sum / (1 + this.model.get('clientNDS') / 100),
            switchOffLimitResetEnabled: Number(this.model.get('remainValue')) > 0,
            switchOffLimitWithNds: limitSettings.sum
        });
        this.setMod(this.elem('row-switch-off-limit'), 'limit-used', 'yes');
    },

    /**
     * Обработчик события сброса порога отключения
     */
    _onSwitchOffLimitReset: function() {
        this.delMod(this.elem('switch-off-limit-hint'), 'hidden');
        this.model.update({
            switchOffLimit: 0,
            switchOffLimitWithNds: 0
        });
        this.delMod(this.elem('row-switch-off-limit'), 'limit-used');
    },

    /**
     * Инициализирует блок настроек уведомлений
     */
    _initNoticeSettingsControls: function() {
        var smsControl = this.findBlockOn('sms-control', 'b-outboard-controls'),
            emailControl = this.findBlockInside('row-email', 'b-outboard-controls');

        // почтовые уведомления
        if (emailControl) {
            this._subscriptionManager.on(
                emailControl,
                'accept',
                function(e) {
                    this.model.set('email', e.block.getInnerBlock().model.get('email'));
                }, this);

            this._subscriptionManager.on(this.model, 'email', 'change', function() {
                this.elem('email-val')[0].setAttribute('title', this.model.get('email'));
            }, this);
        }

        // смс уведомления
        if (smsControl) {
            smsControl.getInnerBlock().on('click-passport-phone', this._showPassportPhoneWarning, this);
        }
    },

    /**
     * Инициализирует блок настроек дневного бюджета на Общий счет
     */
    _initDayBudget: function() {
        this._actionDayBudget = this.findBlockInside('row-daily-budget', 'button');
        this._dayBudgetPopup = this.findBlockOn('day-budget-popup', 'popup');

        this._subscriptionManager.on(this._actionDayBudget, 'click', function() { this.openDayBudgetPopup(); }, this);

        if (this.params.showEditTools === 'day-budget' && this._actionDayBudget &&
            !this._actionDayBudget.hasMod('disabled', 'yes')) {

            this.openDayBudgetPopup();
        }
    },

    /**
     * Открывает и инициализирует попап редактирования дневного бюджета
     */
    openDayBudgetPopup: function(sum) {
        var model = this.model,
            popup = this._dayBudgetPopup,
            originalSum = model.get('dayBudgetSum'),
            walletPopup;

        if (sum !== undefined) {
            model.set('dayBudgetSum', sum);
        }

        popup
            .setContent(BEMHTML.apply({
                block: 'b-wallet-day-budget-popup',
                note: iget2('b-client-wallet', 'rezhim-pokaza-imeet-prioritet', 'Режим показа имеет приоритет перед режимом показа кампании.'),
                cid: this.params.cid,
                value: model.get('dayBudgetSum'),
                mode: model.get('dayBudgetShowMode'),
                isActive: !!model.get('dayBudgetSum'),
                currency: model.get('currentCurrency'),
                isCommonWallet: true,
                isSaveActive: sum !== undefined
            }))
            .show(this._actionDayBudget);

        walletPopup = popup.findBlockInside('b-wallet-day-budget-popup');

        walletPopup.on('save', function(event, data) {
            this.model.update({
                dayBudgetSum: data.value
            });

            popup.hide();
        }, this);

        walletPopup.on('cancel', function() {
            model.set('dayBudgetSum', originalSum);
            popup.hide();
        });

        popup.on('close', function() {
            walletPopup.un('cancel');
            walletPopup.un('save-click');
            walletPopup.un('save');
        });
    },

    /**
     * Показывает в строке «SMS-уведомления» предупреждение
     * «Новый номер будет отображён после сохранения параметров и перезагрузки страницы.»
     * DIRECT-51348
     */
    _showPassportPhoneWarning: function() {
        this.setMod(this.elem('passport-phone-warning'), 'show', 'yes');
    },

    /**
     * Подписывается на изменение порога отключения в модалке оплаты
     * @private
     */
    _initBPaySubscription: function() {
        var bPayBlock = this.findBlockInside('payment-form', 'b-pay');
        if (!bPayBlock) {
            return;
        }

        this._subscriptionManager.on(bPayBlock,'switch-off-limit-changed', function(e, data) {
            this._onSwitchOffLimitSet(data);
        }, this);
    }
});
