BEM.MODEL.decl({ model: 'b-client-wallet' }, {

    /**
     * Текущая валюта пользователя
     */
    currentCurrency: 'string',

    /**
     * Остаток средств
     */
    remainValue: 'number',

    /**
     * НДС
     */
    clientNDS: 'number',

    /**
     * Дневное ограничение
     */
    dayBudgetSum: 'number',

    /**
     * Дневное ограничение форматированая сумма
     */
    dayBudgetSumText: {
        type: 'string',
        dependsFrom: ['dayBudgetSum', 'currentCurrency'],
        calculate: function() {

            return this.get('dayBudgetSum') ?
                u.currencies.formatSum(this.get('currentCurrency'), this.get('dayBudgetSum')) :
                iget2('b-client-wallet', 'ne-zadan', 'не задан');
        }
    },

    /**
     * Режим дневного ограничения
     */
    dayBudgetShowMode: {
        type: 'string',
        default: 'default'
    },

    switchOffLimitWithNds: {
        type: 'number'
    },

    /**
     * Адрес для уведомлений
     */
    email: 'string',

    /**
     * Текст адреса электронной почты для уведомления
     */
    emailText: {
        dependsFrom: ['email'],
        calculate: function() {

            return this.get('email') || iget2('b-client-wallet', 'ne-ukazan', 'не указан');
        }
    },

    /**
     * Номер телефона для sms
     */
    smsPhone: 'string',

    /**
     * Номер телефона для sms текстом
     */
    smsPhoneText: {
        dependsFrom: ['smsPhone'],
        calculate: function() {
            var phone = this.get('smsPhone');

            return phone && phone.replace(/(\d\d)(\d\d)$/, '-$1-$2') || iget2('b-client-wallet', 'ne-ukazan', 'не указан');
        }
    },

    // Порог отключения
    switchOffLimit: {
        type: 'number',
        default: 0
    },

    switchOffLimitResetEnabled: {
        type: 'boolean'
    },

    switchOffLimitMaxValue: {
        type: 'number'
    },

    isNdsAvailable: {
        type: 'boolea'
    },

    switchOffLimitMaxValueWithNds: {
        type: 'number'
    },

    switchOffLimitText: {
        type: 'string',
        dependsFrom: ['switchOffLimit', 'currentCurrency'],
        calculate: function() {
            var limit = this.get('switchOffLimit'),
                currency = this.get('currentCurrency');

            return limit === 0 ?
                u.currencies.formatSum(currency, limit) :
                '\u2013 ' + u.currencies.formatSum(currency, limit);
        }
    },

    switchOffLimitTextWithNds: {
        type: 'string',
        dependsFrom: ['switchOffLimit', 'currentCurrency', 'switchOffLimitWithNds'],
        calculate: function() {
            var limit = this.get('switchOffLimitWithNds'),
                currency = this.get('currentCurrency'),
                textLimit = u.currencies.formatSum(currency, limit) + ' ' + iget2(
                    'b-client-wallet',
                    'with-nds',
                    'с НДС'
                ),
                isNdsAvailable = this.get('isNdsAvailable');

            if (!isNdsAvailable) {
                return;
            }

            return limit === 0 ?
                textLimit :
                '\u2013 ' + textLimit
        }
    },

    switchOffLimitHintText: {
        type: 'string',
        dependsFrom: ['switchOffLimit', 'currentCurrency', 'switchOffLimitMaxValue', 'switchOffLimitWithNds'],
        calculate: function() {
            var limit = this.get('switchOffLimit'),
                isNdsAvailable = this.get('isNdsAvailable'),
                text = [
                    isNdsAvailable ? iget2(
                        'b-client-wallet',
                        'switch-off-limit-hint-2',
                        'Ваши кампании будут остановлены, когда баланс общего счёта достигнет {overdraftLimit}',
                        {
                            overdraftLimit: u.currencies.formatSum(this.get('currentCurrency'), this.get('switchOffLimit'), { delim: '&nbsp;' } )
                        }
                    ) : iget2(
                        'b-client-wallet',
                        'switch-off-limit-hint-without-nds-2',
                        'Ваши кампании будут остановлены, когда баланс общего счёта достигнет {overdraftLimit}',
                        {
                            overdraftLimit: u.currencies.formatSum(this.get('currentCurrency'), this.get('switchOffLimit'), { delim: '&nbsp;' } )
                        }
                    ),
                    '</br>',
                    isNdsAvailable ? iget2(
                        'b-client-wallet',
                        'switch-off-limit-nds2',
                        'Вы можете настроить порог до –{switchOffLimit} (-{switchOffLimitWithNds} с НДС)',
                        {
                            switchOffLimit: u.currencies.formatSum(this.get('currentCurrency'), this.get('switchOffLimitMaxValue'), { delim: '&nbsp;' } ),
                            switchOffLimitWithNds: u.currencies.formatSum(this.get('currentCurrency'), this.get('switchOffLimitMaxValueWithNds'), { delim: '&nbsp;' } )
                        }
                    ) : iget2(
                        'b-client-wallet',
                        'switch-off-limit-hint-no-nds2',
                        'Вы можете настроить порог до –{switchOffLimit}',
                        {
                            switchOffLimit: u.currencies.formatSum(this.get('currentCurrency'), this.get('switchOffLimitMaxValue'), { delim: '&nbsp;' } )
                        }
                    )
                ];

            if (limit > 0) {
                return;
            }

            return text.join('');
        }
    }
});
