block('b-clients-list')(

    def()(function() {
        var data = this.data,
            csrfToken = this['i-global'].csrf_token,
            columns = [
                {
                    key: 'login',
                    title: iget2('b-clients-list', 'login', 'Логин'),
                    transformData: function(row) {

                        var res = [{
                            block: 'link',
                            content: row.login,
                            url: u.formatUrl({
                                host: data.script,
                                query: {
                                    cmd: row.rbac_role == 'manager' ?
                                        'showManagerMyClients' :
                                        data.rbac_role == 'agency' ? 'showClients' : 'showCamps',
                                    ulogin: row.login
                                }
                            })
                        }];

                        (row.not_resident === 'Yes') && res.push({
                            block: 'b-clients-list',
                            elem: 'login-prop',
                            title: iget2('b-clients-list', 'nerezident', 'Нерезидент'),
                            content: ['&nbsp;(', iget2('b-clients-list', 'nr', 'нр'), ')']
                        });

                        hasLoginRights('super_control', 'manager_control', 'support_control', 'limited_support_control') && res.push({
                            block: 'b-clients-list',
                            elem: 'login-prop',
                            content: [
                                '&nbsp;(',
                                {
                                    block: 'link',
                                    url: u.formatUrl({
                                        host: u.consts('balance_admin'),
                                        path: 'clients.xml',
                                        query: {
                                            login: row.login
                                        }
                                    }),
                                    content: iget2('b-clients-list', 'billing', 'биллинг')
                                },
                                ')'
                            ]
                        });

                        return res;
                    }.bind(this)
                },
                {
                    key: 'fio',
                    title: iget2('b-clients-list', 'fio', 'ФИО'),
                    transformData: function(row) {
                        return row.fio && row.fio.toString() || '';
                    }
                },
                {
                    key: 'rbac_role',
                    title: iget2('b-clients-list', 'rol', 'Роль'),
                    transformData: function(row) {
                        return u.getRoleName(row.rbac_role);
                    }
                },
                {
                    key: 'managers_FIO',
                    title: iget2('b-clients-list', 'menedzher', 'Менеджер'),
                    transformData: function(row) {
                        return row.managers.map(function(m) {
                            return {
                                block: 'b-link',
                                url: 'mailto:' + m.email,
                                content: m.fio && m.fio.toString() || ''
                            };
                        });
                    }
                },
                {
                    key: 'agency_FIO',
                    title: iget2('b-clients-list', 'agentstvo', 'Агентство'),
                    transformData: function(row) {
                        return row.agencies.map(function(a) {
                            return [
                                {
                                    block: 'link',
                                    url: 'mailto:' + a.email,
                                    content: a.fio ? a.fio.toString() : ''
                                },
                                a.agency_manager_fio && a.agency_manager_email && {
                                    block: 'b-client-search',
                                    elem: 'agency-manager-link',
                                    content: u.spacer([
                                        iget2('b-clients-list', 'menedzher-101', 'менеджер:'),
                                        {
                                            block: 'link',
                                            url: 'mailto:' + a.agency_manager_email,
                                            content: '(' +
                                                (a.agency_manager_fio && a.agency_manager_fio.toString() || '') + ')'
                                        }
                                    ])
                                }
                            ];
                        });
                    }
                },
                {
                    key: 'freelancer_login',
                    title: iget2('b-clients-list', 'frilancer', 'Специалист'),
                    transformData: function(row) {
                        return row.freelancer_info && {
                            block: 'link',
                            content: row.freelancer_info.login,
                            url: u.formatUrl({
                                host: '/dna/customers',
                                query: {
                                    ulogin: row.freelancer_info.login
                                }
                            })
                        };
                    }
                },
                {
                    key: 'phone',
                    title: iget2('b-clients-list', 'telefon', 'Телефон'),
                    transformData: function(row) {
                        return row.phone && row.phone.toString();
                    }
                },
                {
                    key: 'email',
                    title: iget2('b-clients-list', 'email', 'email'),
                    transformData: function(row) {
                        return row.email ?
                            ({
                                block: 'link',
                                url: 'mailto:' + row.email,
                                content: row.email
                            }) :
                            '';
                    }
                },
                hasLoginRights('support_control', 'limited_support_control', 'super_control', 'is_developer') && {
                    key: 'edit',
                    sortDisable: true,
                    transformData: function(row) {
                        return row.rbac_role != 'empty' ?
                            ({
                                block: 'link',
                                content: iget2('b-clients-list', 'redaktirovat-102', 'редактировать'),
                                url: u.formatUrl({
                                    host: data.SCRIPT_CLEAR,
                                    query: {
                                        cmd: 'modifyUser',
                                        csrf_token: csrfToken,
                                        ulogin: row.login,
                                        rcmd: 'showSearchPage'
                                    }
                                })
                            }) :
                            '';
                    }
                }
            ];

        return this.ctx.clients ? applyNext({ 'ctx.columns': columns }) : '';
    }),

    content()(function() {

        var res = [{
            elem: 'header',
            content: iget2('b-clients-list', 'klienty', 'Клиенты') + ':'
        }];

        res.push({
            block: 'b-data-table',
            mix: [
                {
                    block: 'b-clients-list',
                    elem: 'table'
                },
                {
                    block: 'b-style-table',
                    mods: {
                        theme: 'gray-list'
                    }
                }
            ],
            mods: {
                sortable: 'server',
                'has-num-column': 'yes'
            },
            columns: this.ctx.columns,
            rows: this.ctx.clients,
            mixes: {
                row: [{
                    block: 'b-style-table',
                    elem: 'row'
                }],
                headerRow: [{
                    block: 'b-style-table',
                    elem: 'head'
                }],
                cell: function(key) {
                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        key === 'part-payment' && {
                            block: 'b-client-search',
                            elem: 'part-payment'
                        }
                    ];
                },
                headerCell: function(key) {
                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        },
                        key === 'part-payment' && {
                            block: 'b-client-search',
                            elem: 'part-payment'
                        }
                    ];
                }
            }
        });

        return this.ctx.clients.length ?
            res :
            {
                elem: 'empty-content',
                content: iget2('b-clients-list', 'klienty-ne-naydeny', 'Клиенты не найдены.')
            };
    })
);
