block('b-competitors-banners-list').content()(function() {
    return [
        this.ctx.banners.map(function(banner) {
            return {
                elem: 'banner-container',
                content: {
                    block: 'b-banner-preview',
                    geoIds: banner.geo,
                    geoNames: banner.region,
                    mix: [{
                        block: 'b-competitors-banners-list',
                        elem: 'banner'
                    }],
                    banner: banner,
                    statusOpenStat: banner.statusOpenStat,
                    showGeo: true,
                    publicIdentity: banner.public_identity,
                    hideSitelinks: true,
                    hideDomainParams: true,
                    hideTemplateWarning: true,
                    hideBid: !(this.ctx.userRights.superreader_control || this.ctx.userRights.super_control)
                }
            };
        }, this).reduce(function(acc, bannerBlock, index) {
            acc.push(bannerBlock);

            if (!((index + 1) % 3)) { //в строке по 3 элемента
                acc.push({
                    elem: 'separator',
                    mix: [{ block: 'i-clearfix' }]
                });
            }

            return acc;
        }, [])
    ];
});
