/**
 * b-conditions-display
 * @param {String} ctx.ulogin - логин пользователя
 * @param {Number} [ctx.retCondId] - id условия (для редактирования)
 * @param {Number} [ctx.retId] - id свзки группа + условие (для редактирования)
 */
block('b-conditions-display')(

    js()(function() {
        return {
            ulogin: this.ctx.ulogin,
            retId: this.ctx.retId,
            retCondId: this.ctx.retCondId
        }
    }),

    content()(function() {

        return [
            {
                elem: 'errors'
            },
            {
                elem: 'form'
            },
            { elem: 'loader' },
            { elem: 'error-wrapper' }
        ]

    }),

    elem('error').content()(function() {
        return {
            block: 'b-warning-message',
            mods: { type: 'preview', theme: 'transparent' },
            icon: {
                block: 'icon',
                mods: { 'size-12': 'alert' }
            },
            content: this.ctx.text
        }
    }),

    elem('loader').content()(function() {
        return {
            block: 'spin2',
            mix: {
                block: this.block,
                elem: 'spin'
            },
            mods: { size: 'm', progress: 'yes' }
        }
    })

);
