u.register({
    'b-conditions-display': {
        createErrorsMapper: function() {
            return u['web-api-errors'].makeErrorMapper(
                function(opts) {
                    var idx = opts.idx;

                    return [
                        {
                            path: ['condition_name'],
                            codes: [
                                {
                                    code: 'DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS',
                                    message: function(obj, err) {
                                        return iget2(
                                            'b-conditions-display',
                                            'conditions-name-already-exists',
                                            'Условие показа с таким названием уже существует.'
                                        );
                                    }
                                },
                                {
                                    code: 'StringDefectIds.MUST_CONTAIN_ONLY_SYMBOLS',
                                    message: function(obj, err) {
                                        return iget2(
                                            'b-conditions-display',
                                            'conditions-name-only-letter',
                                            'В названии условия допускается использование только букв латинского, турецкого, русского, украинского, казахского алфавитов, цифр и знаков пунктуации.'
                                        );
                                    }
                                },
                                {
                                    code: 'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX',
                                    message: function(obj, err) {
                                        return iget2(
                                            'b-conditions-display',
                                            'conditions-name-max-length',
                                            'Длина названия не должна превышать 250 символов.'
                                        );
                                    }
                                }
                            ]
                        },
                        {
                            path: ['groups'],
                            codes: [
                                {
                                    code: 'DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS',
                                    message: function(obj, err) {
                                        return iget2(
                                            'b-conditions-display',
                                            'conditions-groups-already-exists',
                                            'Условие показа с таким набором правил уже существует.'
                                        );
                                    }
                                },
                                {
                                    code: 'CollectionDefectIds.INVALID_COLLECTION_SIZE',
                                    message: function(obj, err) {
                                        return iget2(
                                            'b-conditions-display',
                                            'conditions-groups-limit',
                                            'Превышен лимит целей.'
                                        );
                                    }
                                }
                            ]
                        },
                        {
                            path: ['_all'],
                            codes: [
                                {
                                    code: 'DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS',
                                    message: function(obj, err) {
                                        return iget2(
                                            'b-conditions-display',
                                            'conditions-already-exists',
                                            'Такое условие показа уже существует.'
                                        );
                                    }
                                }
                            ]
                        },
                        {
                            path: ['retargetingsInterests', idx],
                            codes: [
                                {
                                    code: 'RetargetingDefectIds.Gen.REQUIRED_TIME_FOR_GOAL_OR_SEGMENT',
                                    message: function(obj, err) {

                                        return iget2(
                                            'b-conditions-display',
                                            'required-time-or-goal-segment',
                                            'Количество дней должно быть целым числом от 1 до 90'
                                        );
                                    }
                                }
                            ]
                        }
                    ]
                },
                function(obj, err) {
                    return err.text ||
                        iget2(
                            'b-conditions-display',
                            'unknow-error',
                            'Не удалось сохранить условие показа'
                        );
                }
            );
        }
    }
});
