BEM.DOM.decl('b-confirm', {}, {

    /**
     * @private
     * @type {Function}
     */
    _onYes: null,

    /**
     * @private
     * @type {Function}
     */
    _onNo: null,

    /**
     * @private
     * @type {BEM}
     */
    _instance: null,

    /**
     * @private
     * @type {BEM}
     */
    _popup: null,

    /**
     * @private
     * @type {BEM}
     */
    _buttonYes: null,

    /**
     * @private
     * @type {BEM}
     */
    _buttonNo: null,

    /**
     * @private
     * @type {BEM}
     */
    _owner: null,

    /**
     * Открывает попап с сообщением и кнопками подтверждения, отмены
     * @param {Object} [options]
     *     @param {String} options.message сообщение
     *     @param {jQuery} options.fromLink ссылка на которую нужен переход после подтверждения
     *     @param {String} [options.title] заголовок над основным сообщением
     *     @param {String} [options.question] вопрос под основным сообщением
     *     @param {Boolean} [options.limited] устанавливает модификатор _limited_yes
     *     @param {Boolean} [options.overflowHidden] устанавливает модификатор _overflow_hidden
     *     @param {Function} [options.onYes] обработчик клика по кнопке подтверждения
     *     @param {Function} [options.onNo] обработчик клика по кнопке отмены
     *     @param {String} [options.textYes = 'Да'] текст кнопки подтверждения
     *     @param {String} [options.textNo = 'Нет'] текст кнопки отмены
     *     @param {String} [options.type = '' || 'alert'] тип конфирма
     *     @param {Object} [options.fromPopup] ссылка на попап, если вызов был из попапа
     * @param {Object} [ctx] Контекст вызова обработчиков
     */
    open: function(options, ctx) {
        this.afterCurrentEvent(function() {
            var isAlert = options.type === 'alert',
                popup;

            this._isAlert = isAlert;

            this._onYes = options.onYes || options.fromLink && function() {
                this.win.prop('location', options.fromLink.attr('href'));
            };
            this._onNo = options.onNo;
            this._ctx = ctx;
            this._owner = options.fromPopup;

            // @anyakey для DIRECT-54821
            // почему-то для алерта всегда рисуется крестик, что дает пользователю
            // возможность обойти нажатие ОК. Зачем алерту крестик - непонятно,
            // но для b-day-budget2-settings я добавила флаг isAlertUnclosable
            popup = this._setMessage(options.message, options.title, options.question, options.withBullets)
                ._setYesButton(isAlert ? (options.textYes || iget2('b-confirm', 'ok-103', 'ОК')) : (options.textYes || iget2('b-confirm', 'da', 'Да')))
                ._setNoButton(!isAlert && (options.textNo || iget2('b-confirm', 'net', 'Нет')))
                ._getPopup();

            if (this._owner) {
                popup.setParent(this._owner);
            }

            popup
                .setMod('has-close', (isAlert && !options.isAlertUnclosable) || options.hasClose ? 'yes' : 'no')
                .setMod('limited', options.limited ? 'yes' : 'no')
                .setMod('overflow', options.overflowHidden ? 'hidden' : '')
                .onFirst('hide', this._onHide, this)
                .onFirst('show', this._onShow, this)
                .show();

        }, this);
    },

    /**
     * Устанавливает сообщение
     * @private
     * @param {String|Array} message текст сообщения
     * @param {String} title заголовок сообщения
     * @param {String} question вопрос в конфирме
     * @param {Boolean} withBullets список с буллетами
     * @returns {BEM}
     */
    _setMessage: function(message, title, question, withBullets) {
        var messageEl = this._getInstance().elem('message');

        if (message)
            if ($.isArray(message)) {
                messageEl.html(BEMHTML.apply([
                    title && {
                        block: 'b-confirm',
                        elem: 'title',
                        content: title
                    },
                    {
                        block: 'b-menu-vert',
                        mix: [
                            { block: 'b-confirm', elem: 'list' }
                        ],
                        mods: {
                            for: 'confirm',
                            'with-bullets': withBullets ? 'yes' : ''
                        },
                        content: message.map(function(content) {
                            return {
                                elem: 'item',
                                content: content
                            };
                        })
                    },
                    question && {
                        block: 'b-confirm',
                        elem: 'question',
                        content: question
                    }
                ]));
            } else if (({}).toString.call(message) == '[object String]') { // проверка на строку из underscore
                messageEl.html(message);
            } else {
                messageEl.html(BEMHTML.apply(message))
            }

        return this;
    },

    /**
     * Устанавливает текст и действие на кнопку да
     * @private
     * @param {String} text текст кнопки
     * @returns {BEM}
     */
    _setYesButton: function(text) {
        this._getButtonYes()
            .onFirst('click', this._onYesClick, this)
            .elem('text')
            .text(text);

        return this;
    },

    /**
     * Устанавливает текст и действие на кнопку нет или скрывает ее для алерта
     * @private
     * @param {String} text текст кнопки
     * @returns {BEM}
     */
    _setNoButton: function(text) {
        var elem = this._getInstance().elem('no');

        text ?
            this._getInstance().delMod(elem, 'hidden') &&
                this._getButtonNo()
                    .onFirst('click', this._onNoClick, this)
                    .elem('text')
                    .text(text) :
            this._getInstance().setMod(elem, 'hidden', 'yes');

        return this;
    },

    /**
     * Применяет действие для кнопки
     * @private
     * @param {String} type тип кнопки 'yes' или 'no'
     */
    _applyAction: function(type) {

        this._actionWasApplyed = true;

        var action = type === 'yes' || this._isAlert ? this._onYes : this._onNo;

        $.isFunction(action) && action.apply(this._ctx || this);

        // Если попап еще не скрыт
        this._popup && this._getPopup().hide();
    },

    /**
     * Создает общий инстанс попапа
     * @private
     * @returns {BEM}
     */
    _createPopup: function() {
        var popup;

        this.append(this._bPage || (this._bPage = $('.b-page')), popup = $(BEMHTML.apply({
            block: 'popup',
            mods: {
                position: 'fixed',
                type: 'modal',
                autoclosable: 'no',
                'body-scroll': 'no'
            },
            underMods: { type: 'paranja' },
            mix: [{ block: 'b-confirm' }],
            content: [
                {
                    elem: 'content',
                    content: [
                        {
                            block: 'b-confirm',
                            elem: 'message',
                            content: ''
                        },
                        {
                            block: 'button',
                            mods: { size: 'xs' },
                            mix: [{
                                block: 'b-confirm',
                                elem: 'yes'
                            }],
                            type: 'button',
                            content: iget2('b-confirm', 'da', 'Да')
                        },
                        {
                            block: 'button',
                            mods: { size: 'xs' },
                            mix: [{
                                block: 'b-confirm',
                                elem: 'no'
                            }],
                            type: 'button',
                            content: iget2('b-confirm', 'net', 'Нет')
                        },
                        {
                            elem: 'close',
                            content: ''
                        }
                    ]
                }
            ]
        })));

        return popup.bem('popup');
    },

    /**
     * Возвращает инстанс попапа
     * @private
     * @returns {BEM}
     */
    _getPopup: function() {
        return this._popup || (this._popup = this._createPopup());
    },

    /**
     * Действие при скрытии попапа
     * @private
     */
    _onHide: function(e) {
        if (!this._actionWasApplyed) {
            this._applyAction('no');
        }

        this._onYes = this._onNo = null;

        this._getInstance().unbindFromDoc('keydown');

        if (this._owner) {
            //cyn@TODO пока так, позже нужно подебажить почему валится ошибка
            this.afterCurrentEvent(function() {
                BEM.DOM.destruct(this._getInstance().domElem);

                this._instance = this._popup = this._buttonYes = this._buttonNo = null;
            }.bind(this));
        }
    },

    /**
     * Действия при нажатии на кнопку "Да"
     * @private
     */
    _onYesClick: function(e) {
        e.block.domElem.blur();

        this._applyAction('yes');
    },

    /**
     * Действия при нажатии на кнопку "Нет"
     * @private
     */
    _onNoClick: function(e) {
        e.block.domElem.blur();

        this._applyAction('no');
    },

    /**
     * Получаем инстанс блока
     * @private
     * @returns {BEM}
     */
    _getInstance: function() {
        return this._instance || (this._instance = this._getPopup().findBlockOn('b-confirm'));
    },

    /**
     * Действия при показе попапа
     * @private
     */
    _onShow: function() {
        var _this = this;

        this._actionWasApplyed = false;

        //Хромиум ускоряет обработку click-ивентов, в результате событие фокус отрабатывает
        // (ставится модификатор), но не ставится хромовый innerstyle.
        // Хром считает это фичей, сообщество - багой и придумало вот такой воркэраунд
        setTimeout(function() { this._getButtonYes().domElem.focus() }.bind(this), 200);

        this._getInstance().bindToDoc('keydown', function(e) {
            if (e.keyCode === 13) {
                // при нажатии Enter событие проваливается и инициирует ненужные события клика
                e.preventDefault();

                _this._getButtonYes().hasMod('focused', 'yes') && _this._applyAction('yes');
                _this._getButtonNo().hasMod('focused', 'yes') && _this._applyAction('no');
            }
        });
    },

    /**
     * Открывает попап с сообщением
     * @param {String} message сообщение
     * @param {Object} [popup] ссылка на попап из которого был вызов
     */
    alert: function(message, popup) {
        this.open({ message: message, type: 'alert', fromPopup: popup });
    },

    /**
     * Получаем кнопку подтверждения
     * @private
     * @returns {BEM}
     */
    _getButtonYes: function() {
        return this._buttonYes || (this._buttonYes = this._getInstance().findBlockOn('yes', 'button'));
    },

    /**
     * Получаем кнопку отмены
     * @private
     * @returns {BEM}
     */
    _getButtonNo: function() {
        return this._buttonNo || (this._buttonNo = this._getInstance().findBlockOn('no', 'button'));
    }
});
