block('b-content-categories-list-group')(
    content()(function() {
        var ctx = this.ctx,
            contentCategoriesItems = (ctx.contentCategories || []).map(function(id) { return id; }),
            contentCategoriesData = this.data.contentCategoriesData,
            contentCategoriesTree = contentCategoriesData.contentCategoriesTree,
            contentCategoriesIds = contentCategoriesData.contentCategoriesIds,
            сontentCategoriesText = u['content-categories-targeting'].getContentCategoriesText(contentCategoriesItems, contentCategoriesTree, contentCategoriesIds),
            colsNum = ctx.colsNum;

        return [
            {
                block: 'b-content-categories-list-group',
                elem: 'input-block',
                tag: 'tr',
                colsNum: colsNum
            },
            {
                elem: 'group-marker',
                tag: 'tr',
                content: {
                    tag: 'td',
                    attrs: {
                        colspan: colsNum
                    }
                }
            },
            {
                elem: 'content-wrap',
                tag: 'tr',
                content: {
                    elem: 'content',
                    tag: 'td',
                    attrs: {
                        colspan: colsNum
                    },
                    mix: [{
                        block: 'b-style-table',
                        elem: 'cell',
                        elemMods: { first: 'yes' }
                    }],
                    content: {
                        elem: 'categories',
                        tag: 'div',
                        content: сontentCategoriesText
                    }
                }
            }
        ];
    })
);

block('b-content-categories-list-group').elem('input-block')(
    addMix()([{
        block: 'b-style-table',
        elem: 'head',
        elemMods: { type: 'subhead' }
    }]),
    content()(function() {
        return [
            {
                elem: 'subheader-wrapper',
                block: 'b-content-categories-list-group',
                tag: 'td',
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: { first: 'yes' }
                }],
                attrs: {
                    colspan: this.ctx.colsNum
                },
                content: [
                    {
                        elem: 'subheader',
                        content: iget2('b-content-categories-list-group', 'contentCategories', 'Жанры и тематики')
                    }
                ]
            }
        ];
    })
);
