block('b-content-promotion-collection-href')(
    js()(function() {
        return {
            modelParams: {
                name: 'b-content-promotion-collection-href',
                id: this.ctx.modelId,
            },
            modelData: {
                collection_href: this.ctx.collection_href
            },
            errorPath: this.ctx.errorPath
        };
    }),

    content()(function() {
        return [
            {
                block: 'input',
                mods: {
                    size: 's',
                    theme: 'normal'
                },
                mix: [
                    {
                        block: 'b-content-promotion-collection-href',
                        elem: 'input'
                    },
                    {
                        block: 'b-content-promotion-collection-href',
                        elem: 'model-field',
                        js: [
                            {
                                name: 'collection_href',
                                type: 'input'
                            },
                            {
                                name: 'check_collection_in_progress',
                                type: 'mod',
                                block: 'input',
                                modName: 'disabled'
                            }
                        ]
                    }
                ],
                placeholder: iget2('b-content-promotion-collection-href', 'add-collection-link', 'Добавьте ссылку на коллекцию'),
                content: { elem: 'control' },
                value: this.ctx.collection_href
            },
            {
                block: 'spin2',
                mods: {
                    size: 'xxs'
                },
                mix: [
                    {
                        block: 'b-content-promotion-collection-href',
                        elem: 'spinner'
                    },
                    {
                        block: 'b-content-promotion-collection-href',
                        elem: 'model-field',
                        js: {
                            name: 'check_collection_in_progress',
                            type: 'mod',
                            block: 'spin2',
                            modName: 'progress'
                        }
                    }
                ]
            }
        ];
    })
);
