BEM.DOM.decl({ block: 'b-content-promotion-collection-href', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptionManager = BEM.create('i-subscription-manager');
            this._input = this.findBlockOn('input', 'input');
            this._errorPresenter = this.findBlockOutside('b-errors-presenter2');

            this.model.init();

            this._subscriptionManager.wrap(this.model)
                .on('change', function() {
                    this.model.syncToDM();
                }, this)
                .on('collection_href', 'change', function() {
                    this.model.clear('content_promotion_collection_id');
                    this.model.clear('collection_href_checked');
                }, this);

            this._subscriptionManager.wrap(this._input)
                .on('focus', this._onInputFocus, this)
                .on('blur', this._onInputBlur, this);
        }
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this.__base.apply(this, arguments);
    },

    _getHref: function() {
        return this.model.get('collection_href');
    },

    _onInputFocus: function() {
        this._inputValue = this._getHref();
    },

    _onInputBlur: function() {
        var value = this._getHref();

        if (value === this._inputValue) {
            return;
        }
        // если ссылка поменялась
        this._checkCollectionHref();
    },

    _checkCollectionHref: function() {
        if (!this._validateHref()) {
            return;
        }
        this.model.set('check_collection_in_progress', true);

        this._requestCollectionMetaData()
            .then(function(data) {
                this.model.update(data);
            }.bind(this))
            .catch(function(data) {
                this.model.update(data.modelData);
                switch (data.errStatus) {
                    case 500:
                        this._showError(iget2('b-content-promotion-collection-href', 'internal-server-error', 'Внутренняя ошибка сервера'));
                        break;

                    case 410:
                        this._showError(iget2('b-content-promotion-collection-href', 'collection-gone', 'Коллекция недоступна'));
                        break;

                    case 'externalError':
                        this._showError(u['b-content-promotion-collection-href'].processExternalErrors(this.model.get('collectionExternalErrors')));
                        break;

                    default:
                        this._showError(iget2('b-content-promotion-collection-href', 'url-not-collection', 'Введенное значение не является ссылкой на Яндекс.Коллекцию'));
                }
            }.bind(this));
    },

    _validateHref: function() {
        if (!u.isUrl(this._getHref())) {
            this.model.clear('collection_preview_image_href');
            return this._showError(iget2('b-content-promotion-collection-href', 'not-url', 'Введенное значение не является ссылкой'));
        }
        this._clearError();
        return true;
    },

    _requestCollectionMetaData: function() {
        return BEM.blocks['i-web-api-request'].contentPromotion
            .getContentPromotionMetadata(u.consts('ulogin'), 'collection', this._getHref())
            .then(function(data) {
                var modelData = {
                    collection_preview_image_href: data.result.preview_url,
                    content_promotion_collection_id: data.result.content_id,
                    collection_href_checked: true,
                    check_collection_in_progress: false,
                    collectionExternalErrors: u._.get(data, 'validation_result.errors')
                };

                if (!data.success) {
                    throw {
                        status: 'externalError',
                        modelData: modelData
                    }
                }

                return modelData;
            })
            .catch(function(err) {
                throw {
                    modelData: err.modelData || {
                        collection_preview_image_href: undefined,
                        content_promotion_collection_id: undefined,
                        collection_href_checked: true,
                        check_collection_in_progress: false,
                        collectionExternalErrors: undefined
                    },
                    errStatus: err.status
                };
            })
    },

    _showError: function(errorText) {
        if (this._errorPresenter) {
            this._errorPresenter.showErrors([{
                path: this.params.errorPath + '.collection_href',
                description: errorText
            }]);
        }
    },

    _clearError: function() {
        if (this._errorPresenter) {
            this._errorPresenter.clearErrors();
        }
    },

    clear: function() {
        this.model.clear();
    }
});
