u.register({
    'b-content-promotion-collection-href': {
        processExternalErrors: function(externalErrors) {
            return externalErrors.map(function(error) {
                switch (error.code) {
                    case 'ContentPromotionDefectIds.NumberDefectIds.NOT_ENOUGH_CARDS_IN_NEW_COLLECTION':
                        return iget2(
                            'b-content-promotion-collection-href',
                            'not-enough-cards-in-collection',
                            'Недостаточно карточек для размещения коллекции. Минимальное количество – {min}',
                            {
                                min: error.params.min
                            }
                        );

                    default:
                        return iget2(
                            'b-content-promotion-collection-href',
                            'unexpected-error',
                            'Произошла непредвиденная ошибка'
                        );

                }
            }).join('\n');
        }
    }
});
