u.register({
    'b-content-promotion-collection-href': {
        getModelFields: function(withValidation) {
            var fields = {
                collection_href: {
                    type: 'string',
                    validation: {
                        needToValidate: function() {
                            return this.get('collectionExternalErrors').length === 0 &&
                                this.get('content_promotion_content_type') === 'collection';
                        },
                        rules: {
                            required: { text: iget2('b-content-promotion-collection-href', 'collection-href-mandatory', 'Невозможно создать объявление без ссылки на Яндекс.Коллекцию') },
                            shouldBeUrl: {
                                validate: function(val) {
                                    return u.isUrl(val);
                                },
                                text: function() {
                                    return iget2('b-content-promotion-collection-href', 'not-url', 'Введенное значение не является ссылкой');
                                },
                                needToValidate: function(val) {
                                    return !!val;
                                }
                            },
                            shouldBeCollectionHref: {
                                validate: function() {
                                    return !!this.get('content_promotion_collection_id');
                                },
                                text: function() {
                                    return iget2('b-content-promotion-collection-href', 'url-not-collection', 'Введенное значение не является ссылкой на Яндекс.Коллекцию');
                                },
                                needToValidate: function() {
                                    return this.get('collection_href_checked');
                                }
                            }
                        }
                    }
                },

                collection_preview_image_href: 'string',

                check_collection_in_progress: {
                    type: 'boolean',
                    default: false
                },

                content_promotion_collection_id: {
                    type: 'string'
                },

                collection_href_checked: {
                    type: 'boolean',
                    default: false
                },

                collectionExternalErrors: {
                    type: 'array',
                    validation: {
                        rules: {
                            shouldBeEmpty: {
                                validate: function(errors) {
                                    return errors.length === 0;
                                },
                                text: function(errors) {
                                    return u['b-content-promotion-collection-href'].processExternalErrors(errors);
                                }
                            }
                        }
                    },
                    default: []
                }
            };

            if (!withValidation) {
                Object.keys(fields).forEach(function(key) {
                    delete fields[key].validation;
                });
            }

            return fields;
        }
    }
});

BEM.MODEL.decl({ model: 'b-content-promotion-collection-href', baseModel: 'vm-sync-dm' }, Object.assign({}, u['b-content-promotion-collection-href'].getModelFields(), {
    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                name: 'dm-content-promotion-banner',
                id: this.id
            };
        }
    }
}));
